/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kr.jm.utils.enums.OS;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMOptional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMThread {
    private static final Logger log = LoggerFactory.getLogger(JMThread.class);
    public static final long DEFAULT_WAITING_MILLIS = 0L;

    public static BlockingQueue<Runnable> getThreadQueue(ExecutorService executorService) {
        if (executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executorService).getQueue();
        }
        throw JMExceptionManager.handleExceptionAndReturnRuntimeEx(log, new IllegalArgumentException("Unsupported ExecutorService - Use ThrJMThread.newThreadPool Or newSingleThreadPool To Get ExecutorService !!!"), "getThreadQueue", executorService);
    }

    public static int getActiveCount(ExecutorService executorService) {
        return ((ThreadPoolExecutor)executorService).getActiveCount();
    }

    public static long getCompletedTaskCount(ExecutorService executorService) {
        return ((ThreadPoolExecutor)executorService).getCompletedTaskCount();
    }

    public static void purge(ExecutorService executorService) {
        ((ThreadPoolExecutor)executorService).purge();
    }

    public static long getPoolSize(ExecutorService executorService) {
        return ((ThreadPoolExecutor)executorService).getPoolSize();
    }

    public static void shutdownAndWaitToBeTerminated(ExecutorService executorService) {
        if (executorService.isTerminated()) {
            return;
        }
        log.warn("Start Shutdown !!! - {}", (Object)executorService);
        long startTimeMillis = System.currentTimeMillis();
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            JMThread.sleep(100L);
        }
        log.warn("Terminating !!! - {} over {} ms", (Object)executorService, (Object)(startTimeMillis - System.currentTimeMillis()));
    }

    public static List<Runnable> shutdownNowAndWaitToBeTerminated(ExecutorService executorService) {
        if (!executorService.isTerminated()) {
            return Collections.emptyList();
        }
        log.warn("Shutdown Now!!! - {}", (Object)executorService);
        return executorService.shutdownNow();
    }

    public static ExecutorService newThreadPool(int numOfThreads) {
        return numOfThreads < 1 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(numOfThreads);
    }

    public static ExecutorService newSingleThreadPool() {
        return Executors.newFixedThreadPool(1);
    }

    public static ExecutorService newThreadPoolWithAvailableProcessors() {
        return Executors.newFixedThreadPool(OS.getAvailableProcessors());
    }

    public static ExecutorService newThreadPoolWithAvailableProcessorsMinusOne() {
        return Executors.newFixedThreadPool(OS.getAvailableProcessors() - 1);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            JMExceptionManager.logException(log, e, "sleep", millis);
        }
    }

    public static void suspend(long intervalAsMillis, Supplier<Boolean> suspendConditionSupplier) {
        if (!suspendConditionSupplier.get().booleanValue()) {
            return;
        }
        log.warn("Start Suspending !!!");
        long startTimeMillis = System.currentTimeMillis();
        while (suspendConditionSupplier.get().booleanValue()) {
            JMThread.sleep(intervalAsMillis);
        }
        log.warn("Stop Suspending Over {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    public static <R> R suspendWhenNull(long intervalAsMillis, Supplier<R> objectSupplier) {
        R object = objectSupplier.get();
        if (object == null) {
            log.warn("Start Suspending !!!");
            long startTimeMillis = System.currentTimeMillis();
            while ((object = objectSupplier.get()) == null) {
                JMThread.sleep(intervalAsMillis);
            }
            log.warn("Stop Suspending Over {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
        return object;
    }

    public static void run(Runnable runnableWork, long timeoutInSec) {
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        JMThread.afterTimeout(timeoutInSec, threadPool, threadPool.submit(runnableWork));
    }

    private static void afterTimeout(long timeoutInSec, ExecutorService threadPool, Future<?> future) {
        threadPool.execute(() -> {
            try {
                future.get(timeoutInSec, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                JMExceptionManager.logException(log, e, "afterTimeout", timeoutInSec, threadPool, future);
            }
            finally {
                if (!threadPool.isShutdown()) {
                    threadPool.shutdownNow();
                }
            }
        });
    }

    public static <T> Future<T> run(Callable<T> callableWork, long timeoutInSec) {
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        Future<T> future = threadPool.submit(callableWork);
        JMThread.afterTimeout(timeoutInSec, threadPool, future);
        return future;
    }

    public static ForkJoinPool getCommonPool() {
        return ForkJoinPool.commonPool();
    }

    public static <V> ScheduledFuture<V> runWithSchedule(long delayMillis, Callable<V> callable) {
        return JMThread.newSingleScheduledThreadPool().schedule(JMThread.buildCallableWithLogging("runWithSchedule", callable, new Object[0]), delayMillis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledExecutorService newSingleScheduledThreadPool() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        OS.addShutdownHook(scheduledExecutorService::shutdown);
        return scheduledExecutorService;
    }

    public static <V> Callable<V> buildCallableWithLogging(String name, Callable<V> callable, Object ... params) {
        return () -> JMThread.supplyAsync(() -> {
            try {
                JMLog.debug(log, name, System.currentTimeMillis(), params);
                return callable.call();
            }
            catch (Exception e) {
                return JMExceptionManager.handleExceptionAndReturnNull(log, e, name, params);
            }
        }).get();
    }

    public static Runnable buildRunnableWithLogging(String runnableName, Runnable runnable, Object ... params) {
        return () -> {
            JMLog.debug(log, runnableName, System.currentTimeMillis(), params);
            runnable.run();
        };
    }

    public static ScheduledFuture<?> runWithSchedule(long delayMillis, Runnable runnable) {
        return JMThread.newSingleScheduledThreadPool().schedule(JMThread.buildRunnableWithLogging("runWithSchedule", runnable, delayMillis), delayMillis, TimeUnit.MILLISECONDS);
    }

    private static ScheduledFuture<?> runWithScheduleAtFixedRate(long initialDelayMillis, long periodMillis, String name, Runnable runnable) {
        return JMThread.newSingleScheduledThreadPool().scheduleAtFixedRate(JMThread.buildRunnableWithLogging(name, runnable, initialDelayMillis, periodMillis), initialDelayMillis, periodMillis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> runWithScheduleAtFixedRate(long initialDelayMillis, long periodMillis, Runnable runnable) {
        return JMThread.runWithScheduleAtFixedRate(initialDelayMillis, periodMillis, "runWithScheduleAtFixedRate", runnable);
    }

    public static ScheduledFuture<?> runWithScheduleAtFixedRateOnStartTime(ZonedDateTime startDateTime, long periodMillis, Runnable runnable) {
        return JMThread.runWithScheduleAtFixedRate(JMThread.calInitialDelayMillis(startDateTime), periodMillis, "runWithScheduleAtFixedRateOnStartTime", runnable);
    }

    private static ScheduledFuture<?> runWithScheduleWithFixedDelay(long initialDelayMillis, long delayMillis, String name, Runnable runnable) {
        return JMThread.newSingleScheduledThreadPool().scheduleWithFixedDelay(JMThread.buildRunnableWithLogging(name, runnable, initialDelayMillis, delayMillis), initialDelayMillis, delayMillis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> runWithScheduleWithFixedDelay(long initialDelayMillis, long delayMillis, Runnable runnable) {
        return JMThread.runWithScheduleWithFixedDelay(initialDelayMillis, delayMillis, "runWithScheduleWithFixedDelay", runnable);
    }

    private static long calInitialDelayMillis(ZonedDateTime startDateTime) {
        return startDateTime.toInstant().toEpochMilli() - System.currentTimeMillis();
    }

    public static ScheduledFuture<?> runWithScheduleWithFixedDelayOnStartTime(ZonedDateTime startDateTime, long delayMillis, Runnable runnable) {
        return JMThread.runWithScheduleWithFixedDelay(JMThread.calInitialDelayMillis(startDateTime), delayMillis, "runWithScheduleWithFixedDelayOnStartTime", runnable);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return JMThread.runAsync(runnable, JMThread.getCommonPool());
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return JMThread.runAsync(runnable, JMThread.handleExceptionally("runAsync", runnable, executor), executor);
    }

    private static Consumer<Throwable> handleExceptionally(String methodName, Object ... objects) {
        return throwable -> {
            throw JMExceptionManager.handleExceptionAndReturnRuntimeEx(log, throwable, methodName, objects);
        };
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Consumer<Throwable> failureConsumer, Executor executor) {
        return CompletableFuture.runAsync(runnable, executor).exceptionally(e -> {
            JMOptional.ifNotNull(failureConsumer, c -> c.accept(e));
            return (Void)new Object();
        });
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return CompletableFuture.supplyAsync(JMThread.handleSupplierWithException(supplier));
    }

    private static <U> Supplier<U> handleSupplierWithException(Supplier<U> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                return JMExceptionManager.handleExceptionAndReturnNull(log, e, "supplyAsync", supplier);
            }
        };
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return CompletableFuture.supplyAsync(JMThread.handleSupplierWithException(supplier), executor);
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Function<Throwable, U> failureFunction) {
        return CompletableFuture.supplyAsync(supplier).exceptionally(throwable -> JMExceptionManager.handleExceptionAndReturn(log, throwable, "supplyAsync", () -> failureFunction.apply((Throwable)throwable), supplier));
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Function<Throwable, U> failureFunction, Executor executor) {
        return CompletableFuture.supplyAsync(supplier, executor).exceptionally(throwable -> JMExceptionManager.handleExceptionAndReturn(log, throwable, "supplyAsync", () -> failureFunction.apply((Throwable)throwable), supplier, executor));
    }

    public static ExecutorService startWithSingleExecutorService(String message, Runnable runnable) {
        return JMThread.startWithExecutorService(JMThread.newSingleThreadPool(), message, runnable);
    }

    public static ExecutorService startWithExecutorService(String message, Runnable runnable) {
        return JMThread.startWithExecutorService(JMThread.newThreadPoolWithAvailableProcessors(), message, runnable);
    }

    public static ExecutorService startWithExecutorService(ExecutorService executorService, String message, Runnable runnable) {
        JMThread.runAsync(() -> {
            JMLog.info(log, "startWithExecutorService", message);
            runnable.run();
        }, executorService);
        return executorService;
    }

    public static <E> BlockingQueue<E> getLimitedBlockingQueue(int maxQueue) {
        return new LinkedBlockingQueue<E>(maxQueue){

            @Override
            public boolean offer(E e) {
                return JMThread.putInsteadOfOffer(this, e);
            }
        };
    }

    public static <E> BlockingQueue<E> getWaitingLimitedBlockingQueue(final long waitingMillis, final int maxQueue) {
        return new LinkedBlockingQueue<E>(maxQueue){

            @Override
            public boolean offer(E e) {
                if (this.size() >= maxQueue) {
                    JMThread.sleep(waitingMillis);
                    log.warn("Wait For {} ms And Blocking !!! - maxQueue = {}", (Object)waitingMillis, (Object)maxQueue);
                }
                return JMThread.putInsteadOfOffer(this, e);
            }
        };
    }

    private static <E> boolean putInsteadOfOffer(BlockingQueue<E> queue, E e) {
        try {
            queue.put(e);
            return true;
        }
        catch (InterruptedException ie) {
            return JMExceptionManager.handleExceptionAndReturnFalse(log, ie, "offer", e);
        }
    }

    public static ExecutorService newMaxQueueThreadPool(int numWorkerThreads, long waitingMillis, int maxQueue) {
        return new ThreadPoolExecutor(numWorkerThreads, numWorkerThreads, 0L, TimeUnit.MILLISECONDS, waitingMillis > 0L ? JMThread.getWaitingLimitedBlockingQueue(waitingMillis, maxQueue) : JMThread.getLimitedBlockingQueue(maxQueue));
    }

    public static ExecutorService newMaxQueueThreadPool(int numWorkerThreads, int maxQueue) {
        return JMThread.newMaxQueueThreadPool(numWorkerThreads, 0L, maxQueue);
    }

    public static ExecutorService newMaxQueueThreadPool(int maxQueue) {
        return JMThread.newMaxQueueThreadPool(OS.getAvailableProcessors(), maxQueue);
    }
}

