/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMFiles;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMFileAppender
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JMFileAppender.class);
    private Writer writer;
    private Path filePath;

    public JMFileAppender(String filePath) {
        this(JMPath.getPath(filePath));
    }

    public JMFileAppender(Path filePath) {
        this(filePath, StandardCharsets.UTF_8);
    }

    public JMFileAppender(String filePath, Charset charset) {
        this(JMPath.getPath(filePath), charset);
    }

    public JMFileAppender(Path filePath, Charset charset) {
        JMLog.info(log, "JMFileAppender.new", filePath, charset);
        this.writer = JMFiles.buildBufferedAppendWriter(filePath, charset);
        this.filePath = filePath;
    }

    public JMFileAppender append(String string) {
        JMFiles.append(this.writer, string);
        return this;
    }

    public JMFileAppender appendLine(String line) {
        JMFiles.appendLine(this.writer, line);
        return this;
    }

    public static Path appendAndClose(String filePath, Charset charset, String writingString) {
        return new JMFileAppender(filePath, charset).append(writingString).closeAndGetFilePath();
    }

    public Path closeAndGetFilePath() {
        this.close();
        return this.filePath;
    }

    public static Path appendLinesAndClose(String filePath, String ... lines) {
        return JMFileAppender.appendLinesAndClose(filePath, StandardCharsets.UTF_8, lines);
    }

    public static Path appendLinesAndClose(String filePath, Collection<String> lineCollection) {
        return JMFileAppender.appendLinesAndClose(filePath, StandardCharsets.UTF_8, lineCollection);
    }

    public static Path appendLinesAndClose(String filePath, Charset charset, String ... lines) {
        return JMFileAppender.appendLineStreamAndClose(filePath, charset, Arrays.stream(lines));
    }

    public static Path appendLinesAndClose(String filePath, Charset charset, Collection<String> lineCollection) {
        return JMFileAppender.appendLineStreamAndClose(filePath, charset, lineCollection.stream());
    }

    private static Path appendLineStreamAndClose(String filePath, Charset charset, Stream<String> lineStream) {
        return JMFileAppender.appendLineStreamAndClose(new JMFileAppender(filePath, charset), lineStream);
    }

    private static Path appendLineStreamAndClose(JMFileAppender jmFileAppender, Stream<String> lineStream) {
        lineStream.forEach(jmFileAppender::appendLine);
        return jmFileAppender.closeAndGetFilePath();
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            JMExceptionManager.logException(log, e, "close", new Object[0]);
        }
    }
}

