/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMFiles;
import kr.jm.utils.helper.JMInputStream;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMResources {
    private static final Logger log = LoggerFactory.getLogger(JMResources.class);
    public static final String UTF_8_CharsetString = "UTF-8";

    public static void setSystemPropertyIfIsNull(String key, Object value) {
        if (!System.getProperties().containsKey(key)) {
            System.setProperty(key, value.toString());
        }
    }

    public static String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public static URL getResourceURL(String classpath) {
        return ClassLoader.getSystemResource(classpath);
    }

    public static URL getURL(String classpathOrFilePath) {
        try {
            return JMResources.getURI(classpathOrFilePath).toURL();
        }
        catch (MalformedURLException e) {
            return (URL)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getURL", classpathOrFilePath);
        }
    }

    public static URI getResourceURI(String classpath) {
        try {
            return JMResources.getResourceURL(classpath).toURI();
        }
        catch (Exception e) {
            return (URI)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getResourceURI", classpath);
        }
    }

    public static URI getURI(String classpathOrFilePath) {
        return Optional.ofNullable(JMResources.getResourceURI(classpathOrFilePath)).orElseGet(() -> new File(classpathOrFilePath).toURI());
    }

    public static InputStream getResourceInputStream(String classpath) {
        return ClassLoader.getSystemResourceAsStream(classpath);
    }

    public static Properties getProperties(String classpath) {
        Properties properties;
        block8: {
            Properties properties2 = new Properties();
            InputStream is = JMResources.getResourceInputStream(classpath);
            Throwable throwable = null;
            try {
                properties2.load(is);
                properties = properties2;
                if (is == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (is != null) {
                            JMResources.$closeResource(throwable, is);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    return (Properties)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getProperties", classpath);
                }
            }
            JMResources.$closeResource(throwable, is);
        }
        return properties;
    }

    public static Properties getProperties(File propertiesFile) {
        Properties properties;
        Properties properties2 = new Properties();
        BufferedReader reader = new BufferedReader(new FileReader(propertiesFile));
        Throwable throwable = null;
        try {
            properties2.load(reader);
            properties = properties2;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    JMResources.$closeResource(throwable, reader);
                    throw throwable3;
                }
            }
            catch (Exception e) {
                return (Properties)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getProperties", propertiesFile);
            }
        }
        JMResources.$closeResource(throwable, reader);
        return properties;
    }

    public static boolean saveProperties(Properties inProperties, File saveFile, String comment) {
        try {
            if (!saveFile.exists()) {
                JMFiles.createEmptyFile(saveFile);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(saveFile));
            inProperties.store(writer, comment);
            writer.close();
            return true;
        }
        catch (IOException e) {
            return JMExceptionManager.handleExceptionAndReturnFalse(log, e, "saveProperties", inProperties, saveFile, comment);
        }
    }

    public static String readString(String resourceClasspath) {
        return JMInputStream.toString(JMResources.getResourceInputStream(resourceClasspath));
    }

    public static String readString(String resourceClasspath, String charsetName) {
        return JMInputStream.toString(JMResources.getResourceInputStream(resourceClasspath), charsetName);
    }

    public static List<String> readLines(String resourceClasspath) {
        return JMInputStream.readLines(JMResources.getResourceInputStream(resourceClasspath));
    }

    public static List<String> readLines(String resourceClasspath, String charsetName) {
        return JMInputStream.readLines(JMResources.getResourceInputStream(resourceClasspath), charsetName);
    }

    public static String getStringWithClasspathOrFilePath(String classpathOrFilePath) {
        return JMResources.getStringWithClasspathOrFilePath(classpathOrFilePath, UTF_8_CharsetString);
    }

    public static String getStringWithClasspathOrFilePath(String classpathOrFilePath, String charsetName) {
        return JMResources.getStringAsOptWithClasspath(classpathOrFilePath, charsetName).orElseGet(() -> JMResources.getStringAsOptWithFilePath(classpathOrFilePath, charsetName).orElse(null));
    }

    public static List<String> readLinesWithClasspathOrFilePath(String classpathOrFilePath) {
        return JMResources.getStringListAsOptWithClasspath(classpathOrFilePath).filter(JMPredicate.getGreaterSize(0)).orElseGet(() -> JMFiles.readLines(classpathOrFilePath));
    }

    public static Optional<List<String>> getStringListAsOptWithClasspath(String classpathOrFilePath) {
        return JMResources.getResourceInputStreamAsOpt(classpathOrFilePath).map(JMInputStream::readLines);
    }

    public static List<String> readLinesWithFilePathOrClasspath(String filePathOrClasspath) {
        return JMOptional.getOptional(JMFiles.readLines(filePathOrClasspath)).orElseGet(() -> JMResources.getStringListAsOptWithClasspath(filePathOrClasspath).orElseGet(Collections::emptyList));
    }

    public static String getStringWithFilePathOrClasspath(String filePathOrClasspath, String charsetName) {
        return JMResources.getStringAsOptWithFilePath(filePathOrClasspath, charsetName).orElseGet(() -> JMResources.getStringAsOptWithClasspath(filePathOrClasspath, charsetName).orElse(null));
    }

    public static String getStringWithFilePathOrClasspath(String filePathOrClasspath) {
        return JMResources.getStringWithFilePathOrClasspath(filePathOrClasspath, UTF_8_CharsetString);
    }

    public static Optional<String> getStringAsOptWithFilePath(String filePath, String charsetName) {
        return JMOptional.getOptional(JMFiles.readString(filePath, charsetName));
    }

    public static Optional<String> getStringAsOptWithFilePath(String filePath) {
        return JMResources.getStringAsOptWithFilePath(filePath, UTF_8_CharsetString);
    }

    public static Optional<String> getStringAsOptWithClasspath(String classpath, String charsetName) {
        return JMResources.getResourceInputStreamAsOpt(classpath).map(resourceInputStream -> JMInputStream.toString(resourceInputStream, charsetName));
    }

    public static Optional<String> getStringAsOptWithClasspath(String classpath) {
        return JMResources.getStringAsOptWithClasspath(classpath, UTF_8_CharsetString);
    }

    public static Optional<InputStream> getResourceInputStreamAsOpt(String classpath) {
        return Optional.ofNullable(JMResources.getResourceInputStream(classpath));
    }

    public static ResourceBundle getResourceBundle(String baseName) {
        return ResourceBundle.getBundle(baseName);
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale targetLocale) {
        Locale.setDefault(targetLocale);
        return ResourceBundle.getBundle(baseName);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

