/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.datastructure;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kr.jm.utils.helper.JMOptional;

public class JMMap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> List<V> removeAllIfByKey(Map<K, V> map, Predicate<? super K> filter) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.keySet().stream().filter(filter).collect(Collectors.toList()).stream().map(map::remove).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> List<V> removeAllIfByEntry(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).map(Map.Entry::getKey).collect(Collectors.toList()).stream().map(map::remove).collect(Collectors.toList());
        }
    }

    public static <K, V> Stream<Map.Entry<K, V>> getEntryStreamWithFilter(Map<K, V> map, Predicate<? super Map.Entry<K, V>> predicate) {
        return JMMap.buildEntryStream(map).filter(predicate);
    }

    public static <K, V> Stream<Map.Entry<K, V>> buildEntryStream(Map<K, V> map) {
        return map.entrySet().stream();
    }

    public static <K, V> V getOrElse(Map<K, V> map, K key, Supplier<V> valueSupplier) {
        return JMOptional.getOptional(map, key).orElseGet(valueSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutGetNew(Map<K, V> map, K key, Supplier<V> newValueSupplier) {
        Map<Object, Object> map2 = map;
        synchronized (map2) {
            return (V)map.computeIfAbsent(key, k -> newValueSupplier.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, K> V putGetNew(Map<K, V> map, K key, V newValue) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            map.put(key, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, K> V putIfAbsent(Map<K, V> map, K key, Supplier<V> newValueSupplier) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            V v = map.get(key);
            if (v == null) {
                v = map.put(key, newValueSupplier.get());
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK> Map<NK, V> newChangedKeyMap(Map<K, V> map, Function<K, NK> changingKeyFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK> Map<NK, V> newChangedKeyWithEntryMap(Map<K, V> map, Function<Map.Entry<K, V>, NK> changingKeyFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).collect(Collectors.toMap(changingKeyFunction::apply, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK> Map<NK, V> newFilteredChangedKeyMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter, Function<K, NK> changingKeyFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK> Map<NK, V> newFilteredChangedKeyWithEntryMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter, Function<Map.Entry<K, V>, NK> changingKeyFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).collect(Collectors.toMap(changingKeyFunction::apply, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NV> Map<K, NV> newChangedValueMap(Map<K, V> map, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).collect(Collectors.toMap(Map.Entry::getKey, entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NV> Map<K, NV> newChangedValueWithEntryMap(Map<K, V> map, Function<Map.Entry<K, V>, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).collect(Collectors.toMap(Map.Entry::getKey, changingValueFunction::apply));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NV> Map<K, NV> newFilteredChangedValueMap(Map<K, V> map, Predicate<Map.Entry<K, V>> filter, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).collect(Collectors.toMap(Map.Entry::getKey, entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NV> Map<K, NV> newFilteredChangedValueWithEntryMap(Map<K, V> map, Predicate<Map.Entry<K, V>> filter, Function<Map.Entry<K, V>, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).collect(Collectors.toMap(Map.Entry::getKey, changingValueFunction::apply));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK, NV> Map<NK, NV> newChangedKeyValueMap(Map<K, V> map, Function<K, NK> changingKeyFunction, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK, NV> Map<NK, NV> newFilteredChangedKeyValueMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter, Function<K, NK> changingKeyFunction, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK, NV> Map<NK, NV> newChangedKeyValueWithEntryMap(Map<K, V> map, Function<Map.Entry<K, V>, NK> changingKeyFunction, Function<Map.Entry<K, V>, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).collect(Collectors.toMap(changingKeyFunction::apply, changingValueFunction::apply));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK, NV> Map<NK, NV> newFilteredChangedKeyValueWithEntryMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter, Function<Map.Entry<K, V>, NK> changingKeyFunction, Function<Map.Entry<K, V>, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).collect(Collectors.toMap(changingKeyFunction::apply, changingValueFunction::apply));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> newFilteredMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.getEntryStreamWithFilter(map, filter).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> sort(Map<K, V> map, Comparator<K> comparator) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            TreeMap<K, V> sortedMap = new TreeMap<K, V>(comparator);
            sortedMap.putAll(map);
            return sortedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K extends Comparable<K>, V> Map<K, V> sort(Map<K, V> map) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return new TreeMap<K, V>(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Stream<Map.Entry<K, V>> sortedStream(Map<K, V> map, Comparator<? super Map.Entry<K, V>> comparator) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).sorted(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K extends Comparable<K>, V> Stream<Map.Entry<K, V>> sortedStream(Map<K, V> map) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).sorted(Comparator.comparing(Map.Entry::getKey));
        }
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortByValue(Map<K, V> map) {
        return JMMap.sort(map, Comparator.comparing(map::get));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V extends Comparable<V>> Stream<Map.Entry<K, V>> sortedStreamByValue(Map<K, V> map) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return JMMap.buildEntryStream(map).sorted(Comparator.comparing(Map.Entry::getValue));
        }
    }

    public static boolean isNotNullOrEmpty(Map<?, ?> map) {
        return !JMMap.isNullOrEmpty(map);
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static <K, V> Map<K, V> newCombinedMap(K[] keys, V[] values) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], JMMap.getValueOfIndex(values, i));
        }
        return map;
    }

    private static <V> V getValueOfIndex(V[] values, int i) {
        try {
            return values[i];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Object> newFlatKeyMap(Map<String, ?> map) {
        return JMMap.newFlatKeyMap(new HashMap<String, Object>(), map);
    }

    private static Map<String, Object> newFlatKeyMap(Map<String, Object> newMap, Map<String, ?> map) {
        map.forEach((key, value) -> JMMap.newFlatKeyMap(newMap, key, value));
        return newMap;
    }

    private static void newFlatKeyMap(Map<String, Object> newMap, String parentKey, Object value) {
        if (value instanceof Map) {
            JMMap.newFlatKeyMap(newMap, JMMap.newChangedKeyMap((Map)value, key -> parentKey + "." + key));
        } else {
            newMap.put(parentKey, value);
        }
    }
}

