/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import kr.jm.utils.helper.JMOptional;

public class JMLimitedQueue<E>
implements Collection<E> {
    private int capacity;
    private LinkedBlockingQueue<E> linkedBlockingQueue;

    public JMLimitedQueue(int capacity) {
        this.capacity = capacity;
        this.linkedBlockingQueue = new LinkedBlockingQueue(capacity);
    }

    public Optional<E> poll() {
        return JMOptional.getOptional(this.linkedBlockingQueue).map(LinkedBlockingQueue::poll);
    }

    public Optional<E> peek() {
        return Optional.ofNullable(this.linkedBlockingQueue.peek());
    }

    @Override
    public boolean add(E e) {
        if (this.capacity <= this.linkedBlockingQueue.size()) {
            this.linkedBlockingQueue.remove();
        }
        return this.linkedBlockingQueue.add(e);
    }

    @Override
    public int size() {
        return this.linkedBlockingQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.linkedBlockingQueue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.linkedBlockingQueue.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.linkedBlockingQueue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.linkedBlockingQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.linkedBlockingQueue.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.linkedBlockingQueue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.linkedBlockingQueue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.linkedBlockingQueue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.linkedBlockingQueue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.linkedBlockingQueue.retainAll(c);
    }

    @Override
    public void clear() {
        this.linkedBlockingQueue.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.linkedBlockingQueue.equals(o);
    }

    @Override
    public int hashCode() {
        return this.linkedBlockingQueue.hashCode();
    }
}

