/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kr.jm.utils.helper.JMLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMRegex {
    private static final Logger log = LoggerFactory.getLogger(JMRegex.class);
    private List<String> groupNameList;
    private Pattern pattern;

    public JMRegex(String regex) {
        this(regex, 0);
    }

    public JMRegex(String regex, int flag) {
        this.groupNameList = this.getMatchedPartList(Pattern.compile("\\(\\?<\\w+>").matcher(regex)).stream().map(s -> s.substring(s.indexOf(60) + 1, s.indexOf(62))).collect(Collectors.toList());
        this.pattern = flag == 0 ? Pattern.compile(regex) : Pattern.compile(regex, flag);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public List<String> getGroupNameList() {
        return Collections.unmodifiableList(this.groupNameList);
    }

    public String toString() {
        return "JMRegex{pattern=" + this.pattern + '}';
    }

    public boolean isMatchedWithPart(String targetString) {
        return this.pattern.matcher(targetString).lookingAt();
    }

    public boolean isMatchedWithEntire(String targetString) {
        return this.pattern.matcher(targetString).matches();
    }

    public List<String> getMatchedPartList(String targetString) {
        return this.getMatchedPartList(this.pattern.matcher(targetString));
    }

    private List<String> getMatchedPartList(Matcher matcher) {
        ArrayList<String> matchedList = new ArrayList<String>();
        while (matcher.find()) {
            matchedList.add(matcher.group());
        }
        return matchedList;
    }

    public List<String> getMatchedListByGroup(String targetString) {
        return this.getMatcherAsOpt(targetString).map(matcher -> IntStream.rangeClosed(1, matcher.groupCount()).mapToObj(matcher::group).map(Object::toString).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    public Map<String, String> getGroupNameValueMap(String targetString) {
        return this.getMatcherAsOpt(targetString).map(matcher -> this.groupNameList.stream().collect(Collectors.toMap(Function.identity(), matcher::group))).orElseGet(Collections::emptyMap);
    }

    private Optional<Matcher> getMatcherAsOpt(String targetString) {
        Optional matcherAsOpt = Optional.of(this.pattern.matcher(targetString)).filter(Matcher::matches);
        return matcherAsOpt.isPresent() ? matcherAsOpt : (Optional)((Object)JMLambda.runAndReturn(() -> log.warn("Wrong Match Pattern Occur !!! - pattern = {}, targetString = {}", (Object)this.pattern.pattern(), (Object)targetString), Optional::empty));
    }
}

