/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.enums.OS;
import kr.jm.utils.helper.JMLambda;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPredicate;
import kr.jm.utils.helper.JMStream;
import kr.jm.utils.helper.JMString;

public class JMPath {
    private static final OS os = OS.getOS();
    public static final FileSystem FS = FileSystems.getDefault();
    public static final Predicate<Path> DirectoryFilter = x$0 -> Files.isDirectory(x$0, new LinkOption[0]);
    public static final Predicate<Path> RegularFileFilter = x$0 -> Files.isRegularFile(x$0, new LinkOption[0]);
    public static final Predicate<Path> ExecutableFilter = Files::isExecutable;
    public static final Predicate<Path> ReadableFilter = Files::isReadable;
    public static final Predicate<Path> WritableFilter = Files::isWritable;
    public static final Predicate<Path> SymbolicLinkFilter = Files::isSymbolicLink;
    public static final Predicate<Path> HiddenFilter = JMPath::isHidden;
    public static final Predicate<Path> NotExistFilter = x$0 -> Files.notExists(x$0, new LinkOption[0]);
    public static final Predicate<Path> ExistFilter = x$0 -> Files.exists(x$0, new LinkOption[0]);
    public static final Predicate<Path> DirectoryAndNotSymbolicLinkFilter = DirectoryFilter.and(SymbolicLinkFilter.negate());
    public static final Comparator<Path> directoryFirstComparator = (p1, p2) -> JMPath.isDirectory(p1) && !JMPath.isDirectory(p2) ? -1 : (!JMPath.isDirectory(p1) && JMPath.isDirectory(p2) ? 1 : p1.compareTo((Path)p2));

    public static boolean isDirectory(Path path) {
        return DirectoryFilter.test(path);
    }

    public static boolean isRegularFile(Path path) {
        return RegularFileFilter.test(path);
    }

    public static boolean isExecutable(Path path) {
        return ExecutableFilter.test(path);
    }

    public static boolean isReadable(Path path) {
        return ReadableFilter.test(path);
    }

    public static boolean isWritable(Path path) {
        return WritableFilter.test(path);
    }

    public static boolean isSymbolicLink(Path path) {
        return SymbolicLinkFilter.test(path);
    }

    public static boolean notExists(Path path) {
        return NotExistFilter.test(path);
    }

    public static boolean exists(Path path) {
        return ExistFilter.test(path);
    }

    public static boolean isDirectoryAndNotSymbolicLink(Path path) {
        return DirectoryAndNotSymbolicLinkFilter.test(path);
    }

    public static List<FileStore> getFileStoreList() {
        return JMCollections.buildList(FS.getFileStores());
    }

    public static List<Path> getFileStorePathList() {
        return JMPath.getFileStoreList().stream().map(Object::toString).map(toString -> toString.substring(0, toString.indexOf(" "))).map(JMPath::getPath).collect(Collectors.toList());
    }

    public static boolean isHidden(Path path) {
        try {
            return Files.isHidden(path);
        }
        catch (IOException e) {
            return true;
        }
    }

    public static Optional<Path> getParentAsOpt(Path path) {
        return Optional.ofNullable(path.getParent()).filter(ExistFilter);
    }

    public static Stream<Path> getRootPathStream() {
        return os.getRootFileList().stream().map(File::toPath);
    }

    public static Stream<Path> getRootDirectoryStream() {
        return JMPath.getRootPathStream().filter(DirectoryFilter);
    }

    public static Path getPath(String path) {
        return FS.getPath(path, new String[0]).toAbsolutePath();
    }

    public static Path getCurrentPath() {
        return JMPath.getPath(OS.getUserWorkingDir());
    }

    public static Path getUserHome() {
        return JMPath.getPath(OS.getUserHomeDir());
    }

    public static Stream<Path> getChildrenPathStream(Path path) {
        return Optional.ofNullable(path.toFile().listFiles()).map(listFiles -> Stream.of(listFiles).map(File::toPath)).orElseGet(Stream::empty);
    }

    public static Stream<Path> getChildrenPathStream(Path path, Predicate<Path> filter) {
        return JMPath.getChildrenPathStream(path).filter(filter);
    }

    public static Stream<Path> getChildDirectoryPathStream(Path path) {
        return JMPath.getChildrenPathStream(path).filter(DirectoryAndNotSymbolicLinkFilter);
    }

    public static Stream<Path> getChildDirectoryPathStream(Path path, Predicate<Path> filter) {
        return JMPath.getChildrenPathStream(path).filter(DirectoryAndNotSymbolicLinkFilter.and(filter));
    }

    public static Stream<Path> getChildFilePathStream(Path path) {
        return JMPath.getChildrenPathStream(path).filter(RegularFileFilter);
    }

    public static Stream<Path> getChildFilePathStream(Path path, Predicate<Path> filter) {
        return JMPath.getChildrenPathStream(path).filter(RegularFileFilter.and(filter));
    }

    public static List<Path> getAncestorPathList(Path startPath) {
        ArrayList<Path> ancestorPathList = new ArrayList<Path>();
        JMPath.buildPathListOfAncestorDirectory(ancestorPathList, startPath);
        Collections.reverse(ancestorPathList);
        return ancestorPathList;
    }

    private static void buildPathListOfAncestorDirectory(List<Path> pathListOfAncestorDirectory, Path path) {
        Optional.ofNullable(path.getParent()).filter(JMPredicate.peek(pathListOfAncestorDirectory::add)).ifPresent(p -> JMPath.buildPathListOfAncestorDirectory(pathListOfAncestorDirectory, p));
    }

    public static List<Path> getSubDirectoryPathList(Path startDirectoryPath) {
        return JMPath.getSubPathList(startDirectoryPath, DirectoryAndNotSymbolicLinkFilter);
    }

    public static List<Path> getSubDirectoryPathList(Path startDirectoryPath, int maxDepth) {
        return JMPath.getSubPathList(startDirectoryPath, maxDepth, DirectoryAndNotSymbolicLinkFilter);
    }

    public static List<Path> getSubDirectoryPathList(Path startDirectoryPath, Predicate<Path> filter) {
        return JMPath.getSubPathList(startDirectoryPath, Integer.MAX_VALUE, DirectoryAndNotSymbolicLinkFilter.and(filter));
    }

    public static List<Path> getSubDirectoryPathList(Path startDirectoryPath, int maxDepth, Predicate<Path> filter) {
        return JMPath.getSubPathList(startDirectoryPath, maxDepth, DirectoryAndNotSymbolicLinkFilter.and(filter));
    }

    public static List<Path> getSubFilePathList(Path startDirectoryPath) {
        return JMPath.getSubPathList(startDirectoryPath, RegularFileFilter);
    }

    public static List<Path> getSubFilePathList(Path startDirectoryPath, int maxDepth) {
        return JMPath.getSubPathList(startDirectoryPath, maxDepth, RegularFileFilter);
    }

    public static List<Path> getSubFilePathList(Path startDirectoryPath, Predicate<Path> filter) {
        return JMPath.getSubPathList(startDirectoryPath, RegularFileFilter.and(filter));
    }

    public static List<Path> getSubFilePathList(Path startDirectoryPath, int maxDepth, Predicate<Path> filter) {
        return JMPath.getSubPathList(startDirectoryPath, maxDepth, RegularFileFilter.and(filter));
    }

    public static List<Path> getSubPathList(Path startDirectoryPath) {
        return JMPath.getSubPathList(startDirectoryPath, Integer.MAX_VALUE);
    }

    public static List<Path> getSubPathList(Path startDirectoryPath, int maxDepth) {
        return JMPath.getSubPathList(startDirectoryPath, maxDepth, JMPredicate.getTrue());
    }

    public static List<Path> getSubPathList(Path startDirectoryPath, Predicate<Path> filter) {
        return JMPath.getSubPathList(startDirectoryPath, Integer.MAX_VALUE, filter);
    }

    public static List<Path> getSubPathList(Path startDirectoryPath, int maxDepth, Predicate<Path> filter) {
        List<Path> subPathList = Collections.synchronizedList(new ArrayList());
        if (JMPath.isDirectory(startDirectoryPath)) {
            JMPath.buildSubPath(startDirectoryPath, maxDepth, filter, subPathList);
        }
        return subPathList;
    }

    private static void buildSubPath(Path startDirectoryPath, int maxDepth, Predicate<Path> filter, List<Path> pathList) {
        ((Stream)JMPath.addAndGetDirectoryStream(pathList, JMPath.getChildrenPathStream(startDirectoryPath), filter).parallel()).forEach(JMPath.getDrillDownFunction(maxDepth, filter, pathList));
    }

    private static Stream<Path> addAndGetDirectoryStream(List<Path> pathList, Stream<Path> pathStream, Predicate<Path> filter) {
        return pathStream.peek(path -> JMLambda.consumeIfTrue(path, filter, pathList::add)).filter(DirectoryAndNotSymbolicLinkFilter);
    }

    private static void drillDown(Path directoryPath, int maxDepth, List<Path> pathList, Predicate<Path> filter) {
        if (maxDepth < 1) {
            return;
        }
        JMPath.addAndGetDirectoryStream(pathList, JMPath.getChildrenPathStream(directoryPath), filter).forEach(JMPath.getDrillDownFunction(maxDepth, filter, pathList));
    }

    private static Consumer<Path> getDrillDownFunction(int maxDepth, Predicate<Path> filter, List<Path> pathList) {
        return path -> JMPath.drillDown(path, maxDepth - 1, pathList, filter);
    }

    public static void consumePathList(boolean isParallel, List<Path> pathList, Consumer<Path> consumer) {
        JMStream.buildStream(isParallel, pathList).forEach(consumer);
    }

    public static void consumePathList(List<Path> pathList, Consumer<Path> consumer) {
        for (Path path : pathList) {
            consumer.accept(path);
        }
    }

    public static void consumeSubFilePaths(Path startDirectoryPath, int maxDepth, Predicate<Path> filter, Consumer<Path> consumer) {
        JMPath.consumePathList(true, JMPath.getSubFilePathList(startDirectoryPath, maxDepth, filter), consumer);
    }

    public static void consumeSubFilePaths(Path startDirectoryPath, Consumer<Path> consumer) {
        JMPath.consumeSubFilePaths(startDirectoryPath, Integer.MAX_VALUE, JMPredicate.getTrue(), consumer);
    }

    public static void consumeSubFilePaths(Path startDirectoryPath, int maxDepth, Consumer<Path> consumer) {
        JMPath.consumeSubFilePaths(startDirectoryPath, maxDepth, JMPredicate.getTrue(), consumer);
    }

    public static void consumeSubFilePaths(Path startDirectoryPath, Predicate<Path> filter, Consumer<Path> consumer) {
        JMPath.consumeSubFilePaths(startDirectoryPath, Integer.MAX_VALUE, filter, consumer);
    }

    public static <R> List<R> applyPathListAndGetResultList(boolean isParallel, List<Path> pathList, Function<Path, R> function) {
        return JMStream.buildStream(isParallel, pathList).map(function).collect(Collectors.toList());
    }

    public static <R> List<R> applyPathListAndGetResultList(List<Path> pathList, Function<Path, R> function) {
        return pathList.parallelStream().map(function).collect(Collectors.toList());
    }

    public static <R> List<R> applySubFilePathsAndGetAppliedList(Path startDirectoryPath, int maxDepth, Predicate<Path> filter, Function<Path, R> function, boolean isParallel) {
        return JMPath.applyPathListAndGetResultList(isParallel, JMPath.getSubFilePathList(startDirectoryPath, maxDepth, filter), function);
    }

    public static <R> List<R> applySubFilePathsAndGetAppliedList(Path startDirectoryPath, int maxDepth, Predicate<Path> filter, Function<Path, R> function) {
        return JMPath.applySubFilePathsAndGetAppliedList(startDirectoryPath, maxDepth, filter, function, true);
    }

    public static <R> List<R> applySubFilePathsAndGetAppliedList(Path startDirectoryPath, Function<Path, R> function) {
        return JMPath.applySubFilePathsAndGetAppliedList(startDirectoryPath, Integer.MAX_VALUE, JMPredicate.getTrue(), function);
    }

    public static <R> List<R> applySubFilePathsAndGetAppliedList(Path startDirectoryPath, int maxDepth, Function<Path, R> function) {
        return JMPath.applySubFilePathsAndGetAppliedList(startDirectoryPath, maxDepth, JMPredicate.getTrue(), function);
    }

    public static <R> List<R> applySubFilePathsAndGetAppliedList(Path startDirectoryPath, Predicate<Path> filter, Function<Path, R> function) {
        return JMPath.applySubFilePathsAndGetAppliedList(startDirectoryPath, Integer.MAX_VALUE, filter, function);
    }

    public static Optional<String> getFilePathExtensionAsOpt(Path path) {
        return JMOptional.getNullableAndFilteredOptional(path, RegularFileFilter).map(JMPath::getLastName).map(JMString::getExtension).filter(JMPredicate.getIsEmpty().negate());
    }

    public static String getLastName(Path path) {
        return path.toFile().getName();
    }

    public static String getPathNameInOS(Path path) {
        return os.getFileName(path.toFile());
    }

    public static long getLastModified(Path path) {
        return path.toFile().lastModified();
    }

    public static String getPathTypeDescription(Path path) {
        return os.getFileTypeDescription(path.toFile());
    }

    public static long getSize(Path path) {
        return path.toFile().length();
    }

    public static int getSubFilesCount(Path dirPath) {
        return JMPath.getSubFilePathList(dirPath).size();
    }

    public static int getSubDirectoriesCount(Path dirPath) {
        return JMPath.getSubDirectoryPathList(dirPath).size();
    }

    public static int getSubPathsCount(Path dirPath) {
        return JMPath.getSubPathList(dirPath).size();
    }

    public static Path extractSubPath(Path basePath, Path sourcePath) {
        return sourcePath.subpath(basePath.getNameCount() - 1, sourcePath.getNameCount());
    }

    public static Path buildRelativeDestinationPath(Path destinationDirPath, Path baseDirPath, Path sourcePath) {
        Path extractSubPath = JMPath.extractSubPath(baseDirPath, sourcePath);
        return destinationDirPath.resolve(extractSubPath);
    }
}

