/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.enums;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import kr.jm.utils.AutoStringBuilder;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OS {
    WINDOWS,
    MAC,
    LINUX;

    private static FileView fileView;
    private static FileSystemView fileSystemView;
    private static final Logger log;
    private static final String fileSeparator;
    private static Predicate<InetAddress> LoopbackFilter;

    public static String getFileSeparator() {
        return fileSeparator;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getUserWorkingDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    public static String getJavaIoTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String buildPath(String ... strings) {
        AutoStringBuilder asb = new AutoStringBuilder(fileSeparator);
        for (String string : strings) {
            asb.append(string);
        }
        return asb.toString();
    }

    public static OS getOS() {
        String os = OS.getOsName().toLowerCase();
        if (os.contains("windows")) {
            return WINDOWS;
        }
        if (os.contains("mac")) {
            return MAC;
        }
        return LINUX;
    }

    public static void addShutdownHook(Runnable runAfterShotdown) {
        Runtime.getRuntime().addShutdownHook(new Thread(runAfterShotdown));
    }

    public boolean open(File file) {
        try {
            Desktop.getDesktop().open(file);
            return true;
        }
        catch (Exception e) {
            return this.openAlternatively(file);
        }
    }

    private boolean openAlternatively(File file) {
        switch (this) {
            case WINDOWS: {
                return this.open("cmd /c ", file);
            }
            case MAC: {
                return this.open("open ", file);
            }
        }
        return this.open("open ", file);
    }

    private boolean open(String runCmd, File file) {
        try {
            String command = runCmd + file.getAbsolutePath();
            JMLog.info(log, "open", command);
            Runtime.getRuntime().exec(command);
            return true;
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnFalse(log, e, "open", runCmd, file.getAbsolutePath());
        }
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getHostname", new Object[0]);
        }
    }

    public static String getIp() {
        return OS.getIpInfo().getHostAddress();
    }

    public static List<String> getIpList() {
        return OS.getIpInfoList().stream().map(InetAddress::getHostAddress).collect(Collectors.toList());
    }

    public static InetAddress getIpInfo() {
        return OS.getDefaultInetAddressAsOpt().filter(OS::isIpv4Address).orElseGet(OS.getIpInfoList().stream().findFirst()::get);
    }

    public static List<InetAddress> getIpInfoList() {
        return OS.getAllInetAddressInfoStream().filter(LoopbackFilter).filter(OS::isIpv4Address).collect(Collectors.toList());
    }

    private static boolean isIpv4Address(InetAddress inetAddress) {
        return inetAddress.getHostAddress().matches("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
    }

    private static Optional<InetAddress> getDefaultInetAddressAsOpt() {
        try {
            return Optional.ofNullable(InetAddress.getLocalHost()).filter(LoopbackFilter);
        }
        catch (Exception e) {
            return (Optional)JMExceptionManager.handleExceptionAndThrowRuntimeEx(log, new RuntimeException("There Is No IP Address !!!"), "getDefaultInetAddressAsOpt", new Object[0]);
        }
    }

    public static List<InetAddress> getAllInetAddressInfoList() {
        return OS.getAllInetAddressInfoStream().collect(Collectors.toList());
    }

    public static Stream<InetAddress> getAllInetAddressInfoStream() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(nic -> Collections.list(nic.getInetAddresses()).stream());
        }
        catch (SocketException e) {
            return (Stream)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getAllInetAddressInfoStream", new Object[0]);
        }
    }

    private static FileSystemView getFileSystemView() {
        return Optional.ofNullable(fileSystemView).orElseGet(FileSystemView::getFileSystemView);
    }

    private static FileView getFileView() {
        return Optional.ofNullable(fileView).orElseGet(() -> {
            JFileChooser jFileChooser = new JFileChooser();
            fileView = jFileChooser.getUI().getFileView(jFileChooser);
            return fileView;
        });
    }

    public Icon getIcon(File file) {
        switch (this) {
            case MAC: {
                return OS.getFileView().getIcon(file);
            }
        }
        return OS.getFileSystemView().getSystemIcon(file);
    }

    public String getFileName(File file) {
        switch (this) {
            case MAC: {
                return OS.getFileView().getName(file);
            }
        }
        return OS.getFileSystemView().getSystemDisplayName(file);
    }

    public String getFileTypeDescription(File file) {
        switch (this) {
            case MAC: {
                return OS.getFileView().getTypeDescription(file);
            }
        }
        return OS.getFileSystemView().getSystemTypeDescription(file);
    }

    public List<File> getRootFileList() {
        return JMCollections.buildList(OS.getFileSystemView().getRoots());
    }

    public static String getFileDescription(File file) {
        return OS.getFileView().getDescription(file);
    }

    public static File getHomeDirctoryFile() {
        return OS.getFileSystemView().getHomeDirectory();
    }

    public static File getDefaultDirctoryFile() {
        return OS.getFileSystemView().getDefaultDirectory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailableLocalPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            socket.setReuseAddress(true);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return JMExceptionManager.handleExceptionAndReturn(log, e, "getAvailableLocalPort", () -> -1, new Object[0]);
        }
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    static {
        log = LoggerFactory.getLogger(OS.class);
        fileSeparator = System.getProperty("file.separator");
        LoopbackFilter = JMPredicate.negate(InetAddress::isLoopbackAddress);
    }
}

