/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kr.jm.utils.exception.JMExceptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMIO {
    private static final Logger log = LoggerFactory.getLogger(JMIO.class);
    private static final String UTF_8 = "UTF-8";
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static String toString(InputStream inputStream) {
        return JMIO.toString(inputStream, UTF_8, new StringBuilder());
    }

    public static String toString(InputStream inputStream, String encoding) {
        return JMIO.toString(inputStream, encoding, new StringBuilder());
    }

    private static String toString(InputStream inputStream, String encoding, StringBuilder stringBuilder) {
        try {
            JMIO.consumeInputStream(inputStream, encoding, line -> JMIO.appendLine(stringBuilder, line));
            return stringBuilder.toString();
        }
        catch (Exception e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "toString", inputStream, encoding);
        }
    }

    private static void appendLine(StringBuilder stringBuilder, String line) {
        stringBuilder.append(line);
        stringBuilder.append(NEW_LINE);
    }

    public static List<String> readLines(InputStream inputStream, String encoding) {
        return JMIO.readLines(inputStream, encoding, new ArrayList<String>());
    }

    public static List<String> readLines(InputStream inputStream) {
        return JMIO.readLines(inputStream, UTF_8, new ArrayList<String>());
    }

    private static List<String> readLines(InputStream inputStream, String encoding, List<String> stringList) {
        try {
            JMIO.consumeInputStream(inputStream, encoding, line -> stringList.add((String)line));
            return stringList;
        }
        catch (Exception e) {
            return (List)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readLines", inputStream, encoding);
        }
    }

    public static void consumeInputStream(InputStream inputStream, String encoding, Consumer<String> consumer) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, encoding));){
            String line = br.readLine();
            while (line != null) {
                consumer.accept(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

