/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.destory;

import java.util.Arrays;
import java.util.List;
import kr.jm.utils.destory.DestroyInterface;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Destroyer {
    private static final Logger log = LoggerFactory.getLogger(Destroyer.class);

    public static <D extends DestroyInterface> void cleanUp(D ... destorys) {
        JMOptional.getOptional(destorys).map(Arrays::asList).ifPresent(Destroyer::cleanUp);
    }

    public static <D extends DestroyInterface> void cleanUp(List<D> destroyList) {
        JMOptional.getOptional(destroyList).ifPresent(list -> list.forEach(Destroyer::cleanUp));
    }

    public static void cleanUp(DestroyInterface destroy) {
        try {
            JMThread.sleep(10L);
            log.info("Start Clean Up - {}", (Object)destroy);
            destroy.cleanUp();
            log.info("Complete Clean Up - {}", (Object)destroy);
        }
        catch (Exception e) {
            log.error("Fail Clean Up - {}", (Object)destroy);
            JMExceptionManager.logException(log, e, "cleanUp", destroy);
            return;
        }
    }
}

