/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.enums;

import java.awt.Desktop;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import kr.jm.utils.AutoStringBuilder;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OS {
    WINDOWS,
    MAC,
    LINUX;

    private static FileView fileView;
    private static FileSystemView fileSystemView;
    private static final Logger log;
    private static final String fileSeparator;

    public static String getFileSeparator() {
        return fileSeparator;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getUserWorkingDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    public static String buildPath(String ... strings) {
        AutoStringBuilder asb = new AutoStringBuilder(fileSeparator);
        for (String string : strings) {
            asb.append(string);
        }
        return asb.toString();
    }

    public static OS getOS() {
        String os = OS.getOsName().toLowerCase();
        if (os.contains("windows")) {
            return WINDOWS;
        }
        if (os.contains("mac")) {
            return MAC;
        }
        return LINUX;
    }

    public boolean open(File file) {
        try {
            Desktop.getDesktop().open(file);
            return true;
        }
        catch (Exception e) {
            return this.openAlternatively(file);
        }
    }

    private boolean openAlternatively(File file) {
        switch (this) {
            case WINDOWS: {
                return this.open("cmd /c ", file);
            }
            case MAC: {
                return this.open("open ", file);
            }
        }
        return this.open("open ", file);
    }

    private boolean open(String runCmd, File file) {
        try {
            String command = runCmd + file.getAbsolutePath();
            JMLog.infoBeforeStart(log, "open", command);
            Runtime.getRuntime().exec(command);
            return true;
        }
        catch (Exception e) {
            return (Boolean)JMExceptionManager.handleExceptionAndReturnNull(log, e, "open", runCmd, file.getAbsolutePath());
        }
    }

    public static String getIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getIp", new Object[0]);
        }
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getHostname", new Object[0]);
        }
    }

    private static FileSystemView getFileSystemView() {
        return Optional.ofNullable(fileSystemView).orElseGet(() -> {
            fileSystemView = FileSystemView.getFileSystemView();
            return fileSystemView;
        });
    }

    private static FileView getFileView() {
        return Optional.ofNullable(fileView).orElseGet(() -> {
            JFileChooser jFileChooser = new JFileChooser();
            fileView = jFileChooser.getUI().getFileView(jFileChooser);
            return fileView;
        });
    }

    public Icon getIcon(File file) {
        switch (this) {
            case MAC: {
                return OS.getFileView().getIcon(file);
            }
        }
        return OS.getFileSystemView().getSystemIcon(file);
    }

    public String getFileName(File file) {
        switch (this) {
            case MAC: {
                return OS.getFileView().getName(file);
            }
        }
        return OS.getFileSystemView().getSystemDisplayName(file);
    }

    public String getFileTypeDescription(File file) {
        switch (this) {
            case MAC: {
                return OS.getFileView().getTypeDescription(file);
            }
        }
        return OS.getFileSystemView().getSystemTypeDescription(file);
    }

    public List<File> getRootFileList() {
        switch (this) {
            case MAC: {
                ArrayList<File> fileList = new ArrayList<File>();
                fileList.add(OS.getDefaultDirctoryFile());
                Optional.ofNullable(new File("/Volumes").listFiles()).map(JMCollections::buildList).ifPresent(fileList::addAll);
                return fileList;
            }
        }
        return JMCollections.buildList(OS.getFileSystemView().getRoots());
    }

    public static String getFileDescription(File file) {
        return OS.getFileView().getDescription(file);
    }

    public static File getHomeDirctoryFile() {
        return OS.getFileSystemView().getHomeDirectory();
    }

    public static File getDefaultDirctoryFile() {
        return OS.getFileSystemView().getDefaultDirectory();
    }

    static {
        log = LoggerFactory.getLogger(OS.class);
        fileSeparator = System.getProperty("file.separator");
    }
}

