/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.helper.JMStream;

public class JMStats {
    public static Number calStats(String statsString, IntSummaryStatistics summaryStatistics) {
        return StatsField.valueOfAlias(statsString).calStats(summaryStatistics);
    }

    public static Number calStats(String statsString, LongSummaryStatistics summaryStatistics) {
        return StatsField.valueOfAlias(statsString).calStats(summaryStatistics);
    }

    public static Number calStats(String statsString, DoubleSummaryStatistics summaryStatistics) {
        return StatsField.valueOfAlias(statsString).calStats(summaryStatistics);
    }

    public static Number calStats(String statsString, IntStream numberStream) {
        return StatsField.valueOfAlias(statsString).calStats(numberStream);
    }

    public static Number calStats(String statsString, LongStream numberStream) {
        return StatsField.valueOfAlias(statsString).calStats(numberStream);
    }

    public static Number calStats(String statsString, DoubleStream numberStream) {
        return StatsField.valueOfAlias(statsString).calStats(numberStream);
    }

    public static Number getPercentileValue(int targetPercentile, List<Number> unorderedNumberList) {
        return JMStats.getPercentileValueWithSorted(targetPercentile, JMStats.sortedDoubleList(unorderedNumberList));
    }

    private static Double getPercentileValueWithSorted(int targetPercentile, List<Double> sortedNumberList) {
        return JMStats.getPercentileValue(targetPercentile, sortedNumberList.size(), sortedNumberList);
    }

    public static Map<Integer, Number> getPercentileValueMap(List<Integer> targetPercentileList, List<Number> numberList) {
        List<Double> sortedDoubleList = JMStats.sortedDoubleList(numberList);
        return targetPercentileList.stream().collect(Collectors.toMap(percentile -> percentile, percentile -> JMStats.getPercentileValueWithSorted(percentile, sortedDoubleList)));
    }

    private static double getPercentileValue(int targetPercentile, int size, List<Double> sortedList) {
        int index = size * JMStats.adjustTargetPercentile(targetPercentile) / 100;
        return index == 0 ? 0.0 : sortedList.get(index - 1);
    }

    private static List<Double> sortedDoubleList(List<Number> numberList) {
        return JMStream.buildDoubleStream(numberList).sorted().boxed().collect(Collectors.toList());
    }

    private static int adjustTargetPercentile(int targetPercentile) {
        return targetPercentile < 0 ? 0 : (targetPercentile > 100 ? 100 : targetPercentile);
    }

    public static <N extends Number> Number min(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? (double)numberList.stream().mapToInt(Number::intValue).min().orElse(0) : (numberList.get(0) instanceof Long ? (double)numberList.stream().mapToLong(Number::longValue).min().orElse(0L) : numberList.stream().mapToDouble(Number::doubleValue).min().orElse(0.0)));
    }

    public static <N extends Number> Number max(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? (double)numberList.stream().mapToInt(Number::intValue).max().orElse(0) : (numberList.get(0) instanceof Long ? (double)numberList.stream().mapToLong(Number::longValue).max().orElse(0L) : numberList.stream().mapToDouble(Number::doubleValue).max().orElse(0.0)));
    }

    public static Number count(List<?> numberList) {
        return numberList.size();
    }

    public static <N extends Number> Number sum(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? (double)numberList.stream().mapToInt(Number::intValue).sum() : (numberList.get(0) instanceof Long ? (double)numberList.stream().mapToLong(Number::longValue).sum() : numberList.stream().mapToDouble(Number::doubleValue).sum()));
    }

    public static <N extends Number> Number average(List<N> numberList) {
        return JMCollections.isNullOrEmpty(numberList) ? 0.0 : (numberList.get(0) instanceof Integer ? numberList.stream().mapToInt(Number::intValue).average().orElse(0.0) : (numberList.get(0) instanceof Long ? numberList.stream().mapToLong(Number::longValue).average().orElse(0.0) : numberList.stream().mapToDouble(Number::doubleValue).average().orElse(0.0)));
    }

    public static enum StatsField {
        sum,
        min,
        max,
        avg,
        count;


        public static StatsField valueOfAlias(String alias) {
            switch (alias.toLowerCase()) {
                case "minimum": {
                    return min;
                }
                case "maximum": {
                    return max;
                }
                case "average": {
                    return avg;
                }
            }
            return StatsField.valueOf(alias);
        }

        public Number calStats(IntStream intStream) {
            switch (this) {
                case sum: {
                    return intStream.sum();
                }
                case min: {
                    return intStream.min().orElse(0);
                }
                case max: {
                    return intStream.max().orElse(0);
                }
                case count: {
                    return intStream.count();
                }
                case avg: {
                    return intStream.average().orElse(0.0);
                }
            }
            return 0;
        }

        public Number calStats(LongStream longStream) {
            switch (this) {
                case sum: {
                    return longStream.sum();
                }
                case min: {
                    return longStream.min().orElse(0L);
                }
                case max: {
                    return longStream.max().orElse(0L);
                }
                case count: {
                    return longStream.count();
                }
                case avg: {
                    return longStream.average().orElse(0.0);
                }
            }
            return 0L;
        }

        public Number calStats(DoubleStream doubleStream) {
            switch (this) {
                case sum: {
                    return doubleStream.sum();
                }
                case min: {
                    return doubleStream.min().orElse(0.0);
                }
                case max: {
                    return doubleStream.max().orElse(0.0);
                }
                case count: {
                    return doubleStream.count();
                }
                case avg: {
                    return doubleStream.average().orElse(0.0);
                }
            }
            return 0.0;
        }

        public Number calStats(IntSummaryStatistics summaryStatistics) {
            switch (this) {
                case sum: {
                    return summaryStatistics.getSum();
                }
                case min: {
                    return summaryStatistics.getMin();
                }
                case max: {
                    return summaryStatistics.getMax();
                }
                case count: {
                    return summaryStatistics.getCount();
                }
                case avg: {
                    return summaryStatistics.getAverage();
                }
            }
            return 0;
        }

        public Number calStats(LongSummaryStatistics summaryStatistics) {
            switch (this) {
                case sum: {
                    return summaryStatistics.getSum();
                }
                case min: {
                    return summaryStatistics.getMin();
                }
                case max: {
                    return summaryStatistics.getMax();
                }
                case count: {
                    return summaryStatistics.getCount();
                }
                case avg: {
                    return summaryStatistics.getAverage();
                }
            }
            return 0L;
        }

        public Number calStats(DoubleSummaryStatistics summaryStatistics) {
            switch (this) {
                case sum: {
                    return summaryStatistics.getSum();
                }
                case min: {
                    return summaryStatistics.getMin();
                }
                case max: {
                    return summaryStatistics.getMax();
                }
                case count: {
                    return summaryStatistics.getCount();
                }
                case avg: {
                    return summaryStatistics.getAverage();
                }
            }
            return 0.0;
        }
    }
}

