/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingDeque;
import kr.jm.utils.helper.JMLambda;
import kr.jm.utils.helper.JMOptional;

public class JMLimitedStack<E>
implements Collection<E> {
    private int capacity;
    private LinkedBlockingDeque<E> linkedBlockingDeque;

    public JMLimitedStack(int capacity) {
        this.capacity = capacity;
        this.linkedBlockingDeque = new LinkedBlockingDeque(capacity);
    }

    public Optional<E> pop() {
        return JMOptional.getOptional(this.linkedBlockingDeque).map(LinkedBlockingDeque::removeLast);
    }

    public Optional<E> peek() {
        return Optional.ofNullable(this.linkedBlockingDeque.peekLast());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        LinkedBlockingDeque<E> linkedBlockingDeque = this.linkedBlockingDeque;
        synchronized (linkedBlockingDeque) {
            return this.capacity > this.linkedBlockingDeque.size() ? this.linkedBlockingDeque.add(e) : Optional.of(this.linkedBlockingDeque.removeFirst()).map(JMLambda.changeInto(this.linkedBlockingDeque.add(e))).get().booleanValue();
        }
    }

    @Override
    public int size() {
        return this.linkedBlockingDeque.size();
    }

    @Override
    public boolean isEmpty() {
        return this.linkedBlockingDeque.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.linkedBlockingDeque.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.linkedBlockingDeque.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.linkedBlockingDeque.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.linkedBlockingDeque.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.linkedBlockingDeque.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.linkedBlockingDeque.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.linkedBlockingDeque.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.linkedBlockingDeque.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.linkedBlockingDeque.retainAll(c);
    }

    @Override
    public void clear() {
        this.linkedBlockingDeque.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.linkedBlockingDeque.equals(o);
    }

    @Override
    public int hashCode() {
        return this.linkedBlockingDeque.hashCode();
    }
}

