/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverFactory
extends WebDriverFactory {
    public static final String BROWSER_NAME = "chrome";

    @Override
    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public static ChromeOptions newChromeOptions(DriverOptions driverOptions) {
        String experimentalOptions;
        Proxy proxy;
        ChromeOptions options = new ChromeOptions();
        if (driverOptions.has(DriverOptions.DriverOption.HEADLESS)) {
            options.setHeadless(driverOptions.getBoolean(DriverOptions.DriverOption.HEADLESS));
        }
        if ((proxy = ChromeDriverFactory.newProxy(driverOptions)) != null) {
            options.setProxy(proxy);
        }
        if (driverOptions.has(DriverOptions.DriverOption.CLI_ARGS)) {
            options.addArguments(driverOptions.getCliArgs());
        }
        if (driverOptions.has(DriverOptions.DriverOption.CHROME_EXTENSION)) {
            options.addExtensions(driverOptions.getChromeExtensions());
        }
        if ((experimentalOptions = driverOptions.get(DriverOptions.DriverOption.CHROME_EXPERIMENTAL_OPTIONS)) != null) {
            String json = "{}";
            try {
                json = Files.asCharSource((File)new File(experimentalOptions), (Charset)Charset.defaultCharset()).read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Map jsonObject = (Map)new Gson().fromJson(json, Map.class);
            for (Map.Entry entry : jsonObject.entrySet()) {
                options.setExperimentalOption((String)entry.getKey(), entry.getValue());
            }
        }
        return options;
    }

    public static void setDriverSpecificCapabilities(DesiredCapabilities caps, DriverOptions driverOptions) {
        ChromeOptions options = ChromeDriverFactory.newChromeOptions(driverOptions);
        caps.setCapability("goog:chromeOptions", (Object)options);
        caps.merge((Capabilities)driverOptions.getCapabilities());
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        ChromeDriverService service = (ChromeDriverService)ChromeDriverFactory.setupBuilder(new ChromeDriverService.Builder(), driverOptions, DriverOptions.DriverOption.CHROMEDRIVER).build();
        ChromeOptions options = ChromeDriverFactory.newChromeOptions(driverOptions);
        options.merge((Capabilities)driverOptions.getCapabilities());
        ChromeDriver driver = new ChromeDriver(service, options);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

