/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public final class JsonUtils {
    private JsonUtils() {
    }

    private static Object parseInternal(JsonReader r) throws IOException {
        JsonToken token = r.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> array = new ArrayList<Object>();
                r.beginArray();
                while (r.hasNext()) {
                    array.add(JsonUtils.parseInternal(r));
                }
                r.endArray();
                return array;
            }
            case BEGIN_OBJECT: {
                LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
                r.beginObject();
                while (r.hasNext()) {
                    object.put(r.nextName(), JsonUtils.parseInternal(r));
                }
                r.endObject();
                return object;
            }
            case STRING: {
                return r.nextString();
            }
            case NUMBER: {
                double number = r.nextDouble();
                if (number % 1.0 == 0.0) {
                    if (-2.147483648E9 <= number || number <= 2.147483647E9) {
                        return (int)number;
                    }
                    return (long)number;
                }
                return number;
            }
            case BOOLEAN: {
                return r.nextBoolean();
            }
            case NULL: {
                return r.nextName();
            }
        }
        throw new IllegalStateException("Invalid token: " + token);
    }

    public static Object parse(String jsonStr) {
        JsonReader r = new JsonReader((Reader)new StringReader(jsonStr));
        try {
            return JsonUtils.parseInternal(r);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

