/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import com.google.common.base.Strings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.runner.model.utils.CommandsJs;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.command.CommandFactory;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.subcommand.SubCommandMap;

public class CommandDumper {
    private static final Pattern GETTER = Pattern.compile("(get|is)([A-Z].*)");

    private CommandDumper() {
    }

    private static String append(String s1, String s2) {
        if (Strings.isNullOrEmpty((String)s1)) {
            return s2;
        }
        return s1 + ", " + s2;
    }

    private static void addCommandInformationFromSubCommandMap(Map<String, String> commands) {
        try {
            SubCommandMap subCommandMap = new SubCommandMap();
            for (Map.Entry<String, ISubCommand<?>> entry : subCommandMap.getMap().entrySet()) {
                String name = entry.getKey();
                ISubCommand<?> subCommand = entry.getValue();
                String info = "";
                info = CommandDumper.append(info, "SR");
                Matcher matcher = GETTER.matcher(name);
                if (matcher.matches()) {
                    String getterInfo = CommandDumper.append(info, "Generated from " + name);
                    String targetName = matcher.group(2);
                    int count = subCommand.getArgumentCount();
                    commands.put(String.format("assert%s(%d)", targetName, count + 1), getterInfo);
                    commands.put(String.format("verify%s(%d)", targetName, count + 1), getterInfo);
                    commands.put(String.format("waitFor%s(%d)", targetName, count + 1), getterInfo);
                    commands.put(String.format("store%s(%d)", targetName, count + 1), getterInfo);
                    if (targetName.endsWith("Present")) {
                        String notName = targetName.replaceFirst("Present$", "NotPresent");
                        commands.put(String.format("assert%s(%d)", notName, count), getterInfo);
                        commands.put(String.format("verify%s(%d)", notName, count), getterInfo);
                        commands.put(String.format("waitFor%s(%d)", notName, count), getterInfo);
                        continue;
                    }
                    commands.put(String.format("assertNot%s(%d)", targetName, count + 1), getterInfo);
                    commands.put(String.format("verifyNot%s(%d)", targetName, count + 1), getterInfo);
                    commands.put(String.format("waitForNot%s(%d)", targetName, count + 1), getterInfo);
                    continue;
                }
                commands.put(name, info);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static void addCommandInformationFromCommandFactory(Map<String, String> commandInfo) {
        String info = "SR";
        for (Map.Entry<String, Constructor<? extends ICommand>> entry : CommandFactory.getCommandEntries()) {
            ICommand cmd;
            String name = entry.getKey();
            Constructor<? extends ICommand> ctr = entry.getValue();
            try {
                cmd = ctr.newInstance(-1, name);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                continue;
            }
            int count = cmd.getArgumentCount();
            String addInfo = commandInfo.containsKey(name) ? ",Override" : "";
            commandInfo.put(String.format("%s(%d)", name, count), info + addInfo);
        }
        commandInfo.put("store", info);
    }

    private static void showValue(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            return;
        }
        System.out.printf("- %s: %s%n", key, value);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            HashMap<String, String> commandInfo = new HashMap<String, String>();
            CommandDumper.addCommandInformationFromSubCommandMap(commandInfo);
            CommandDumper.addCommandInformationFromCommandFactory(commandInfo);
            commandInfo.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEach(entry -> System.out.println((String)entry.getKey() + "," + (String)entry.getValue()));
        } else if ("--side".equals(args[0])) {
            CommandFactory commandFactory = new CommandFactory();
            CommandsJs commandsJs = CommandsJs.load();
            System.out.println("* Supported status of Selenium IDE commands:");
            commandsJs.getCommands().forEach((name, cmd) -> {
                ICommand srCmd = null;
                int srACnt = 0;
                try {
                    srCmd = commandFactory.newCommand(-1, (String)name, new String[0]);
                    srACnt = srCmd.getArgumentCount();
                }
                catch (SeleneseRunnerRuntimeException seleneseRunnerRuntimeException) {
                    // empty catch block
                }
                int aCnt = 0;
                if (cmd.get("target") != null) {
                    ++aCnt;
                }
                if (cmd.get("value") != null) {
                    ++aCnt;
                }
                String state = srCmd == null ? "--" : (srACnt != aCnt ? "IC" : "OK");
                System.out.printf("  [%s] %s (%d/%d)%n", state, name, srACnt, aCnt);
            });
        } else if ("--side-commands-info".equals(args[0])) {
            CommandsJs commandsJs = CommandsJs.load();
            System.out.println("* Information of Selenium IDE commands:");
            System.out.println();
            commandsJs.getCommands().forEach((name, info) -> {
                System.out.printf("[%s] - %s%n", name, info.get("name"));
                CommandDumper.showValue(info, "type");
                CommandDumper.showValue(info, "description");
                CommandDumper.showValue(info, "target");
                CommandDumper.showValue(info, "value");
                System.out.println();
            });
        }
    }
}

