/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.subcommand;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.subcommand.AbstractSubCommand;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class GetTable
extends AbstractSubCommand<String> {
    private static final Pattern TABLE_PARTS = Pattern.compile("(.*)\\.(\\d+)\\.(\\d+)");
    private static final int ARG_TABLE_CELL_ADDRESS = 0;

    public GetTable() {
        super(ArgumentType.VALUE);
    }

    @Override
    public String execute(Context context, String ... args) {
        Matcher matcher = TABLE_PARTS.matcher(args[0]);
        if (!matcher.matches()) {
            throw new SeleneseRunnerRuntimeException("Invalid target format. Correct format is tableName.rowNum.columnNum");
        }
        WebDriver driver = context.getWrappedDriver();
        String tableLocator = matcher.group(1);
        WebElement table = context.getElementFinder().findElement(driver, tableLocator);
        long row = Long.parseLong(matcher.group(2));
        long col = Long.parseLong(matcher.group(3));
        Object result = context.getJSLibrary().getTable(driver, table, row, col);
        if (result instanceof WebElement) {
            return ((WebElement)result).getText().trim();
        }
        throw new SeleneseRunnerRuntimeException((String)result);
    }
}

