/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.io.InputStream;
import jp.vmi.selenium.runner.model.side.SideFile;
import jp.vmi.selenium.runner.model.side.SideProject;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.SourceType;
import jp.vmi.selenium.selenese.TestCaseMap;
import jp.vmi.selenium.selenese.TestCaseParser;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.parser.SideCommandIterator;
import jp.vmi.selenium.selenese.parser.SideTestSuiteIterator;
import jp.vmi.selenium.selenese.parser.TestProjectReader;
import jp.vmi.selenium.selenese.parser.TestSuiteIterator;

public class SideTestProjectReader
implements TestProjectReader {
    private final SideProject side;
    private final TestCaseMap testCaseMap = new TestCaseMap();

    public static SideTestProjectReader newInstance(String filename, InputStream is) throws InvalidSeleneseException {
        SideProject side = SideFile.parse(filename, is);
        return new SideTestProjectReader(side);
    }

    private SideTestProjectReader(SideProject side) {
        this.side = side;
    }

    @Override
    public TestSuiteIterator getTestSuiteIterator() throws InvalidSeleneseException {
        return new SideTestSuiteIterator(this.side);
    }

    @Override
    public void setupTestCaseMap(SourceType sourceType, ICommandFactory commandFactory) {
        this.side.getTestMap().keySet().forEach(id -> {
            SideCommandIterator iter = new SideCommandIterator(this.side, (String)id);
            TestCaseParser.parse(sourceType, iter, this, commandFactory);
        });
    }

    @Override
    public String getId() {
        return this.side.getId();
    }

    @Override
    public TestCaseMap getTestCaseMap() {
        return this.testCaseMap;
    }
}

