/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.parser.ParserUtils;
import jp.vmi.selenium.selenese.parser.SeleneseCommandIterator;
import jp.vmi.selenium.selenese.parser.SeleneseTestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestElementIterator;
import org.apache.xpath.XPathAPI;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SeleneseIteratorFactory {
    private static final String TEST_CASE_PROFILE = "http://selenium-ide.openqa.org/profiles/test-case";
    private static final String DEFAULT_BASE_URL = "about:blank";
    private final String filename;
    private final Document document;

    public static SeleneseIteratorFactory newInstance(String filename) throws InvalidSeleneseException {
        SeleneseIteratorFactory seleneseIteratorFactory;
        FileInputStream is = new FileInputStream(filename);
        try {
            seleneseIteratorFactory = SeleneseIteratorFactory.newInstance(filename, is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidSeleneseException(e, filename, ParserUtils.getNameFromFilename(filename));
            }
        }
        ((InputStream)is).close();
        return seleneseIteratorFactory;
    }

    public static SeleneseIteratorFactory newInstance(String filename, InputStream is) throws InvalidSeleneseException {
        try {
            DOMParser dp = new DOMParser();
            dp.setEntityResolver(null);
            dp.setFeature("http://xml.org/sax/features/namespaces", false);
            dp.setFeature("http://apache.org/xml/features/include-comments", true);
            dp.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
            dp.parse(new InputSource(is));
            Document document = dp.getDocument();
            SeleneseIteratorFactory seleneseIteratorFactory = new SeleneseIteratorFactory(filename, document);
            return seleneseIteratorFactory;
        }
        catch (IOException | SAXException e) {
            throw new InvalidSeleneseException(e, filename, null);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private SeleneseIteratorFactory(String filename, Document document) {
        this.filename = filename;
        this.document = document;
    }

    public String getFilename() {
        return this.filename;
    }

    public TestElementIterator<?> newIterator() throws InvalidSeleneseException {
        try {
            Node seleniumBase = XPathAPI.selectSingleNode((Node)this.document, (String)"/HTML/HEAD/LINK[@rel='selenium.base']/@href");
            if (seleniumBase != null) {
                String baseURL = seleniumBase.getNodeValue();
                return new SeleneseCommandIterator(this.filename, this.document, baseURL);
            }
            Node profile = XPathAPI.selectSingleNode((Node)this.document, (String)"/HTML/HEAD/@profile");
            if (profile != null && TEST_CASE_PROFILE.equals(profile.getNodeValue())) {
                return new SeleneseCommandIterator(this.filename, this.document, DEFAULT_BASE_URL);
            }
            Node suiteTable = XPathAPI.selectSingleNode((Node)this.document, (String)"/HTML/BODY/TABLE[@id='suiteTable']");
            if (suiteTable != null) {
                return new SeleneseTestCaseIterator(this.filename, this.document);
            }
        }
        catch (TransformerException e) {
            throw new InvalidSeleneseException(e, this.filename, null);
        }
        throw new InvalidSeleneseException("Not selenese script. Missing neither 'selenium.base' link nor table with 'suiteTable' id", this.filename, null);
    }
}

