/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.transform.TransformerException;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.parser.AbstractTestElementIterator;
import jp.vmi.selenium.selenese.parser.CommandEntry;
import jp.vmi.selenium.selenese.parser.CommandIterator;
import jp.vmi.selenium.selenese.parser.NodeIterator;
import jp.vmi.selenium.selenese.parser.ParserUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeleneseCommandIterator
extends AbstractTestElementIterator<CommandEntry>
implements CommandIterator {
    private static final AtomicLong sequence = new AtomicLong(0L);
    private final String baseURL;
    private final NodeIterator nodeIterator;
    private CommandEntry next;

    private static String nextId() {
        return String.format("%08x", sequence.incrementAndGet());
    }

    public SeleneseCommandIterator(String filename, Document document, String baseURL) throws InvalidSeleneseException {
        super(filename);
        this.setId(filename);
        this.baseURL = baseURL;
        String name = ParserUtils.getNameFromFilename(filename);
        try {
            name = XPathAPI.selectSingleNode((Node)document, (String)"//THEAD/TR/TD").getTextContent();
            Node tbody = XPathAPI.selectSingleNode((Node)document, (String)"//TBODY");
            NodeList trList = tbody.getChildNodes();
            this.nodeIterator = new NodeIterator(trList);
        }
        catch (TransformerException | DOMException e) {
            throw new InvalidSeleneseException(e, filename, this.getName());
        }
        this.setName(name);
        this.next = this.nextImpl();
    }

    @Override
    public String getBaseURL() {
        return this.baseURL;
    }

    private static String getTdString(Node td) {
        StringBuilder value = new StringBuilder();
        for (Node node : NodeIterator.each(td.getChildNodes())) {
            if ("BR".equals(node.getNodeName())) {
                value.append('\n');
                continue;
            }
            short nodeType = node.getNodeType();
            if (nodeType != 3 && nodeType != 4) continue;
            value.append(node.getTextContent());
        }
        return value.toString();
    }

    private CommandEntry nextImpl() {
        while (this.nodeIterator.hasNext()) {
            Node tr = this.nodeIterator.next();
            switch (tr.getNodeType()) {
                case 1: {
                    ArrayList<String> cmdWithArgs = new ArrayList<String>(3);
                    for (Node td : NodeIterator.each(tr.getChildNodes())) {
                        if (!"TD".equals(td.getNodeName())) continue;
                        cmdWithArgs.add(SeleneseCommandIterator.getTdString(td));
                    }
                    String cmdName = (String)cmdWithArgs.remove(0);
                    String[] cmdArgs = cmdWithArgs.toArray(new String[cmdWithArgs.size()]);
                    return CommandEntry.newInstance(SeleneseCommandIterator.nextId(), cmdName, cmdArgs);
                }
                case 8: {
                    return CommandEntry.newInstance(SeleneseCommandIterator.nextId(), "comment", tr.getNodeValue().trim());
                }
            }
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public CommandEntry next() {
        CommandEntry value = this.next;
        this.next = this.nextImpl();
        return value;
    }
}

