/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.mutator;

import java.util.function.Function;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.mutator.MutatorUtils;
import jp.vmi.selenium.selenese.mutator.ScriptMutator;
import org.apache.commons.text.StringEscapeUtils;

public class VariableDeclarationWithDynamicValue
implements ScriptMutator {
    private final Pattern pattern;
    private final String declaration;
    private final Function<Context, String> dynamicValue;

    public VariableDeclarationWithDynamicValue(String varName, Function<Context, String> dynamicValue) {
        this.pattern = MutatorUtils.generatePatternForCodePresence(varName);
        this.declaration = varName.indexOf(46) < 0 ? "var " + varName + " = '" : varName + " = '";
        this.dynamicValue = dynamicValue;
    }

    @Override
    public void mutate(Context context, String script, StringBuilder outputTo) {
        if (this.pattern.matcher(script).find()) {
            String value = this.dynamicValue.apply(context);
            outputTo.append(this.declaration).append(StringEscapeUtils.escapeEcmaScript((String)value)).append("';");
        }
    }
}

