/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.javascript;

import java.util.Map;
import jp.vmi.selenium.selenese.ModifierKeyState;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.javascript.JSFunction;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class JSLibrary {
    private final JSFunction replaceAlertMethod;
    private final JSFunction getNextAlert;
    private final JSFunction isAlertPresent;
    private final JSFunction setNextConfirmationState;
    private final JSFunction getNextConfirmation;
    private final JSFunction isConfirmationPresent;
    private final JSFunction answerOnNextPrompt;
    private final JSFunction getNextPrompt;
    private final JSFunction isPromptPresent;
    private final JSFunction triggerKeyEvent;
    private final JSFunction setCursorPosition;
    private final JSFunction getCursorPosition;
    private final JSFunction getElementIndex;
    private final JSFunction isOrdered;
    private final JSFunction getTable;
    private final JSFunction getText;
    private final JSFunction fireEvent;

    public JSLibrary() {
        Map<String, JSFunction> jsMap = JSFunction.load(JSLibrary.class.getResourceAsStream("JSLibrary.js"));
        this.replaceAlertMethod = jsMap.get("replaceAlertMethod");
        this.getNextAlert = jsMap.get("getNextAlert");
        this.isAlertPresent = jsMap.get("isAlertPresent");
        this.setNextConfirmationState = jsMap.get("setNextConfirmationState");
        this.getNextConfirmation = jsMap.get("getNextConfirmation");
        this.isConfirmationPresent = jsMap.get("isConfirmationPresent");
        this.answerOnNextPrompt = jsMap.get("answerOnNextPrompt");
        this.getNextPrompt = jsMap.get("getNextPrompt");
        this.isPromptPresent = jsMap.get("isPromptPresent");
        this.triggerKeyEvent = jsMap.get("triggerKeyEvent");
        this.setCursorPosition = jsMap.get("setCursorPosition");
        this.getCursorPosition = jsMap.get("getCursorPosition");
        this.getElementIndex = jsMap.get("getElementIndex");
        this.isOrdered = jsMap.get("isOrdered");
        this.getTable = jsMap.get("getTable");
        this.getText = jsMap.get("getText");
        this.fireEvent = JSFunction.loadFunction(JSLibrary.class.getResourceAsStream("fireEvent.js"));
    }

    public void replaceAlertMethod(WebDriver driver, WebElement element) {
        this.replaceAlertMethod.call(driver, element);
    }

    public String getNextAlert(WebDriver driver) {
        String result = (String)this.getNextAlert.call(driver, new Object[0]);
        if (result == null) {
            throw new SeleneseRunnerRuntimeException("There were no alerts");
        }
        return result;
    }

    public boolean isAlertPresent(WebDriver driver) {
        return Boolean.TRUE.equals(this.isAlertPresent.call(driver, new Object[0]));
    }

    public void setNextConfirmationState(WebDriver driver, boolean state) {
        this.setNextConfirmationState.call(driver, state);
    }

    public String getNextConfirmation(WebDriver driver) {
        String result = (String)this.getNextConfirmation.call(driver, new Object[0]);
        if (result == null) {
            throw new SeleneseRunnerRuntimeException("There were no confirmations");
        }
        return result;
    }

    public boolean isConfirmationPresent(WebDriver driver) {
        return Boolean.TRUE.equals(this.isConfirmationPresent.call(driver, new Object[0]));
    }

    public void answerOnNextPrompt(WebDriver driver, String msg) {
        this.answerOnNextPrompt.call(driver, msg);
    }

    public String getNextPrompt(WebDriver driver) {
        String result = (String)this.getNextPrompt.call(driver, new Object[0]);
        if (result == null) {
            throw new SeleneseRunnerRuntimeException("There were no prompts");
        }
        return result;
    }

    public boolean isPromptPresent(WebDriver driver) {
        return Boolean.TRUE.equals(this.isPromptPresent.call(driver, new Object[0]));
    }

    public void triggerKeyEvent(WebDriver driver, WebElement element, KeyEventType eventType, String keySequence, ModifierKeyState keyState) {
        int keyCode;
        if (keySequence.codePointCount(0, keySequence.length()) == 1) {
            keyCode = keySequence.codePointAt(0);
        } else {
            try {
                keyCode = keySequence.startsWith("\\") ? Integer.parseInt(keySequence.substring(1)) : Integer.parseInt(keySequence);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid keySequence");
            }
        }
        this.triggerKeyEvent.call(driver, element, eventType.toString(), keyCode, keyState.isControlKeyDown(), keyState.isAltKeyDown(), keyState.isShiftKeyDown(), keyState.isMetaKeyDown());
    }

    public void setCursorPosition(WebDriver driver, WebElement element, int position) {
        this.setCursorPosition.call(driver, element, position);
    }

    public long getCursorPosition(WebDriver driver, WebElement element) {
        return (Long)this.getCursorPosition.call(driver, element);
    }

    public long getElementIndex(WebDriver driver, WebElement element) {
        return (Long)this.getElementIndex.call(driver, element);
    }

    public boolean isOrdered(WebDriver driver, WebElement element1, WebElement element2) {
        return Boolean.TRUE.equals(this.isOrdered.call(driver, element1, element2));
    }

    public Object getTable(WebDriver driver, WebElement table, long row, long col) {
        return this.getTable.call(driver, table, row, col);
    }

    public String getText(WebDriver driver, WebElement element) {
        return (String)this.getText.call(driver, element);
    }

    public void fireEvent(WebDriver driver, WebElement element, String eventName) {
        this.fireEvent.call(driver, element, eventName);
    }

    public static enum KeyEventType {
        KEYDOWN,
        KEYPRESS,
        KEYUP;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

