/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OptionEntry {
    public final String optionName;
    public final Class<?> type;
    private final Method getter;
    private final Method setter;
    private final Method adder;

    private static String propName(String name) {
        StringBuilder methodName = new StringBuilder(name.length());
        for (String word : name.split("-")) {
            methodName.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return methodName.toString();
    }

    public static OptionEntry newInstance(Class<?> beanClass, String optionName) {
        if (optionName.toLowerCase().equals("class")) {
            throw new IllegalArgumentException("Invalid option name: " + optionName);
        }
        String propName = OptionEntry.propName(optionName);
        try {
            Method getter;
            try {
                getter = beanClass.getMethod("get" + propName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                getter = beanClass.getMethod("is" + propName, new Class[0]);
            }
            Class<?> type = getter.getReturnType();
            Method setter = null;
            try {
                setter = beanClass.getMethod("set" + propName, type);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Method adder = null;
            if (type.isArray()) {
                try {
                    adder = beanClass.getMethod("add" + propName, type.getComponentType());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return new OptionEntry(optionName, type, getter, setter, adder);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Invalid option name: " + optionName);
        }
    }

    private OptionEntry(String optionName, Class<?> type, Method getter, Method setter, Method adder) {
        this.optionName = optionName;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
        this.adder = adder;
    }

    public <T> T get(Object obj) {
        try {
            return (T)this.getter.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException("Invalid option value", e);
        }
    }

    public void set(Object obj, Object value) {
        if (this.setter == null) {
            throw new UnsupportedOperationException("set " + this.optionName);
        }
        try {
            this.setter.invoke(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Cannot assign: (%s) %s <- (%s) %s", this.type, this.optionName, value.getClass(), value), e);
        }
    }

    public void add(Object obj, Object value) {
        if (this.adder == null) {
            throw new UnsupportedOperationException("add " + this.optionName);
        }
        try {
            this.adder.invoke(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Cannot assign: %s", value), e);
        }
    }
}

