/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.google.common.base.Strings;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.SeleneseCommandErrorException;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.Wait;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForPageToLoad
extends AbstractCommand {
    private static final Logger log = LoggerFactory.getLogger(WaitForPageToLoad.class);
    private static final int ARG_TIMEOUT = 0;

    WaitForPageToLoad(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    public boolean mayUpdateScreen() {
        return false;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String arg;
        long timeout = 0L;
        if (curArgs.length > 0 && !Strings.isNullOrEmpty((String)(arg = curArgs[0]))) {
            try {
                timeout = Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                return new Error(e);
            }
        }
        return WaitForPageToLoad.execute(context, timeout);
    }

    public static Result execute(Context context, long timeout) {
        Wait.StopCondition condition;
        if (timeout < 0L) {
            return new Error("Illegal timeout parameter: " + timeout);
        }
        if (timeout == 0L) {
            return Success.SUCCESS;
        }
        long startTime = System.currentTimeMillis();
        WebDriver driver = context.getWrappedDriver();
        if (!(driver instanceof JavascriptExecutor)) {
            return new Error("WebDriver is not support JavaScript.");
        }
        Wait.StopCondition stopCondition = condition = WaitForPageToLoad.isReadyStateSupported(driver) ? WaitForPageToLoad.checkByReadyState(driver) : WaitForPageToLoad.checkByBodyLength(driver);
        if (!Wait.defaultInterval.wait(startTime, timeout, condition)) {
            return new Error("Failed to load page within " + timeout + " ms");
        }
        return Success.SUCCESS;
    }

    private static boolean isReadyStateSupported(WebDriver driver) {
        try {
            return WaitForPageToLoad.isReadyStateSupportedInternal(driver);
        }
        catch (WebDriverException webDriverException) {
            Wait.sleep(250L);
            try {
                return WaitForPageToLoad.isReadyStateSupportedInternal(driver);
            }
            catch (WebDriverException webDriverException2) {
                Wait.sleep(500L);
                try {
                    return WaitForPageToLoad.isReadyStateSupportedInternal(driver);
                }
                catch (WebDriverException e) {
                    throw new SeleneseCommandErrorException("Cannot determine whether page supports ready state.");
                }
            }
        }
    }

    private static boolean isReadyStateSupportedInternal(WebDriver driver) {
        Boolean result = (Boolean)((JavascriptExecutor)driver).executeScript("return !!document['readyState'];", new Object[0]);
        return result != null ? result : false;
    }

    private static Wait.StopCondition checkByReadyState(final WebDriver driver) {
        return new Wait.StopCondition(){

            @Override
            public boolean isSatisfied() {
                try {
                    Boolean result = (Boolean)((JavascriptExecutor)driver).executeScript("return document.readyState === 'complete';", new Object[0]);
                    if (result != null && result.booleanValue()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        };
    }

    private static Wait.StopCondition checkByBodyLength(final WebDriver driver) {
        return new Wait.StopCondition(){
            private int prevLen = -1;
            private long prevTime = 0L;

            @Override
            public boolean isSatisfied() {
                WebElement body;
                try {
                    body = driver.findElement(By.tagName((String)"body"));
                }
                catch (NoSuchElementException e) {
                    return false;
                }
                String text = body.getText();
                if (text == null) {
                    return false;
                }
                int len = text.length();
                long now = System.currentTimeMillis();
                if (this.prevLen == len) {
                    return now - this.prevTime > 1000L;
                }
                this.prevLen = len;
                this.prevTime = now;
                return false;
            }
        };
    }
}

