/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.FlowControlState;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.BlockStartImpl;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;

public class Times
extends BlockStartImpl {
    private static final int ARG_TIMES = 0;
    private static final int ARG_LOOP_LIMIT = 1;
    private static final String LOOP_LIMIT_MESSAGE = "Max retry limit exceeded (count=%d/limit=%d). To override it, specify a new limit in the value input field";

    Times(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE, ArgumentType.VALUE);
    }

    @Override
    public boolean isLoopBlock() {
        return true;
    }

    private static long getLongValue(Context context, String s) {
        return ((Number)context.executeScript("return (" + s + ")", new Object[0])).longValue();
    }

    private static long getLoopLimit(Context context, String[] args, int index) {
        if (index >= args.length) {
            return Long.MAX_VALUE;
        }
        String s = args[index];
        if (s == null || s.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return Times.getLongValue(context, s);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        long times = Times.getLongValue(context, curArgs[0]);
        long loopLimit = Times.getLoopLimit(context, curArgs, 1);
        TimesState state = (TimesState)context.getFlowControlState(this);
        if (state == null || state.isAlreadyFinished) {
            state = new TimesState();
            context.setFlowControlState(this, state);
        }
        state.incrementCount();
        if (state.hasReachedLoopLimit(loopLimit)) {
            return new Error(String.format(LOOP_LIMIT_MESSAGE, state.getCount(), loopLimit));
        }
        if (state.hasReachedTimes(times)) {
            context.getCommandListIterator().jumpTo(this.blockEnd);
            return new Success("Finished " + times + " times repitition");
        }
        String msg = loopLimit != Long.MAX_VALUE ? String.format("Times (count=%d/times=%d/limit=%d)", state.getCount(), times, loopLimit) : String.format("Times (count=%d/times=%d)", state.getCount(), times);
        return new Success(msg);
    }

    private static class TimesState
    implements FlowControlState {
        private boolean isAlreadyFinished = false;
        private long count = 0L;

        private TimesState() {
        }

        void incrementCount() {
            ++this.count;
        }

        long getCount() {
            return this.count;
        }

        @Override
        public boolean isAlreadyFinished() {
            return this.isAlreadyFinished;
        }

        boolean hasReachedTimes(long times) {
            if (!this.isAlreadyFinished && this.count > times) {
                this.isAlreadyFinished = true;
            }
            return this.isAlreadyFinished;
        }

        boolean hasReachedLoopLimit(long loopLimit) {
            if (this.isAlreadyFinished || loopLimit == Long.MAX_VALUE) {
                return false;
            }
            return this.count > loopLimit;
        }
    }
}

