/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.Wait;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFrame
extends AbstractCommand {
    private static final Logger log = LoggerFactory.getLogger(SelectFrame.class);
    private static final int ARG_LOCATOR = 0;
    private static long RETRY_INTERVAL = 100L;
    private static long MILLI_TO_NANO = 1000000L;

    SelectFrame(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String locator = curArgs[0];
        WebDriver driver = context.getWrappedDriver();
        WebDriverElementFinder elementFinder = context.getElementFinder();
        long timeout = (long)context.getTimeout() * MILLI_TO_NANO;
        long start = System.nanoTime();
        while (true) {
            try {
                elementFinder.selectFrame(driver, locator);
                return Success.SUCCESS;
            }
            catch (NoSuchFrameException e) {
                if (System.nanoTime() - start > timeout) {
                    log.warn("Timed out select frame: {}", (Object)locator);
                    throw e;
                }
                Wait.sleep(RETRY_INTERVAL);
                continue;
            }
            break;
        }
    }
}

