/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.UnableToSetCookieException;

public class CreateCookie
extends AbstractCommand {
    private static final int ARG_NAME_VALUE_PAIR = 0;
    private static final int ARG_OPTIONS_STRING = 1;
    private static final Pattern NAME_VALUE_PAIR_PATTERN = Pattern.compile("([^\\s=\\[\\]\\(\\),\"\\/\\?@:;]+)=([^\\[\\]\\(\\),\"\\/\\?@:;]*)");
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("max_age=(\\d+)");
    private static final Pattern PATH_PATTERN = Pattern.compile("path=([^\\s,]+)[,]?");

    CreateCookie(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE, ArgumentType.VALUE);
    }

    @Override
    public boolean mayUpdateScreen() {
        return false;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        block8: {
            String nameValuePair = curArgs[0];
            String optionsString = curArgs[1];
            Matcher nameValuePairMatcher = NAME_VALUE_PAIR_PATTERN.matcher(nameValuePair);
            if (!nameValuePairMatcher.find()) {
                return new Error("Invalid parameter: " + nameValuePair);
            }
            String name = nameValuePairMatcher.group(1);
            String value = nameValuePairMatcher.group(2);
            Matcher maxAgeMatcher = MAX_AGE_PATTERN.matcher(optionsString);
            Date maxAge = null;
            if (maxAgeMatcher.find()) {
                maxAge = new Date(System.currentTimeMillis() + (long)(Integer.parseInt(maxAgeMatcher.group(1)) * 1000));
            }
            String path = null;
            Matcher pathMatcher = PATH_PATTERN.matcher(optionsString);
            if (pathMatcher.find()) {
                path = pathMatcher.group(1);
                try {
                    if (path.startsWith("http")) {
                        path = new URL(path).getPath();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            Cookie cookie = new Cookie(name, value, path, maxAge);
            try {
                context.getWrappedDriver().manage().addCookie(cookie);
            }
            catch (InvalidCookieDomainException | UnableToSetCookieException e) {
                if (context.isBrowser("phantomjs")) break block8;
                throw e;
            }
        }
        return Success.SUCCESS;
    }
}

