/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import com.assertthat.selenium_shutterbug.core.Shutterbug;
import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jp.vmi.html.result.HtmlResult;
import jp.vmi.html.result.HtmlResultHolder;
import jp.vmi.junit.result.JUnitResult;
import jp.vmi.junit.result.JUnitResultHolder;
import jp.vmi.selenium.rollup.RollupRules;
import jp.vmi.selenium.selenese.AlertActionListener;
import jp.vmi.selenium.selenese.CollectionMap;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.ErrorSource;
import jp.vmi.selenium.selenese.Eval;
import jp.vmi.selenium.selenese.FlowControlState;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.MaxTimeActiveTimer;
import jp.vmi.selenium.selenese.MaxTimeTimer;
import jp.vmi.selenium.selenese.ModifierKeyState;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.ScreenshotHandler;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.SourceType;
import jp.vmi.selenium.selenese.SubCommandMapProvider;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.TestCaseMap;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.VarsMap;
import jp.vmi.selenium.selenese.command.CommandFactory;
import jp.vmi.selenium.selenese.command.CommandListIterator;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.highlight.HighlightHandler;
import jp.vmi.selenium.selenese.highlight.HighlightStyle;
import jp.vmi.selenium.selenese.highlight.HighlightStyleBackup;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.javascript.JSLibrary;
import jp.vmi.selenium.selenese.locator.Locator;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.log.CookieFilter;
import jp.vmi.selenium.selenese.log.LogFilter;
import jp.vmi.selenium.selenese.log.PageInformation;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Unexecuted;
import jp.vmi.selenium.selenese.subcommand.SubCommandMap;
import jp.vmi.selenium.selenese.utils.LangUtils;
import jp.vmi.selenium.selenese.utils.MouseUtils;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.WebDriverPreparator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.openqa.selenium.Alert;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner
implements Context,
ScreenshotHandler,
HighlightHandler,
JUnitResultHolder,
HtmlResultHolder {
    private static final Logger log = LoggerFactory.getLogger(Runner.class);
    private static final DateTimeFormatter FILE_DATE_TIME = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmssSSS");
    private static PrintStream DEFAULT_PRINT_STREAM = new PrintStream((OutputStream)new NullOutputStream());
    private PrintStream ps;
    private WebDriver driver = null;
    private WebDriverPreparator preparator = null;
    private String overridingBaseURL = null;
    private String initialWindowHandle = null;
    private String screenshotDir = null;
    private String screenshotAllDir = null;
    private String screenshotOnFailDir = null;
    private boolean isIgnoredScreenshotCommand = false;
    private boolean isHighlight = false;
    private boolean isInteractive = false;
    private Boolean isW3cAction = null;
    private int timeout = 30000;
    private int retries = 0;
    private int maxRetries = 0;
    private long initialSpeed = 0L;
    private long speed = 0L;
    private int screenshotScrollTimeout = 100;
    private final Eval eval;
    private final SubCommandMap subCommandMap;
    private final WebDriverElementFinder elementFinder;
    private final CommandFactory commandFactory;
    private TestCase currentTestCase = null;
    private final Deque<CommandListIterator> commandListIteratorStack = new ArrayDeque<CommandListIterator>();
    private VarsMap varsMap;
    private TestCaseMap testCaseMap;
    private final Map<ICommand, FlowControlState> flowControlMap = new IdentityHashMap<ICommand, FlowControlState>();
    private final CollectionMap collectionMap = new CollectionMap();
    private RollupRules rollupRules = null;
    private final Deque<HighlightStyleBackup> styleBackups;
    private PageInformation latestPageInformation = PageInformation.EMPTY;
    private final EnumSet<LogFilter> logFilter = LogFilter.all();
    private CookieFilter cookieFilter = CookieFilter.ALL_PASS;
    private JSLibrary jsLibrary = new JSLibrary();
    private final ModifierKeyState modifierKeyState = new ModifierKeyState(this);
    private final JUnitResult jUnitResult = new JUnitResult();
    private final HtmlResult htmlResult = new HtmlResult();
    private MaxTimeTimer maxTimeTimer = new MaxTimeTimer(){};
    private final AlertActionListener alertActionListener = new AlertActionListener(){
        private boolean accept = true;
        private String answer = null;

        @Override
        public void setAccept(boolean accept) {
            this.accept = accept;
        }

        @Override
        public void setAnswer(String answer) {
            this.answer = answer;
        }

        @Override
        public void actionPerformed(Alert alert) {
            if (this.answer != null) {
                alert.sendKeys(this.answer);
            }
            if (this.accept) {
                alert.accept();
            } else {
                alert.dismiss();
            }
            this.answer = null;
            this.accept = true;
        }
    };

    public Runner() {
        this.ps = DEFAULT_PRINT_STREAM;
        this.eval = new Eval();
        this.elementFinder = new WebDriverElementFinder();
        this.subCommandMap = new SubCommandMap();
        this.commandFactory = new CommandFactory((SubCommandMapProvider)this);
        this.varsMap = new VarsMap();
        this.testCaseMap = TestCaseMap.EMPTY;
        this.styleBackups = new ArrayDeque<HighlightStyleBackup>();
    }

    public void setCommandLineArgs(String[] args) {
        this.jUnitResult.setCommandLineArgs(args);
        this.htmlResult.setCommandLineArgs(args);
    }

    @Override
    public TestCase getCurrentTestCase() {
        return this.currentTestCase;
    }

    @Override
    public void setCurrentTestCase(TestCase currentTestCase) {
        this.currentTestCase = currentTestCase;
    }

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.ps;
    }

    protected TakesScreenshot getTakesScreenshot() {
        if (this.driver instanceof TakesScreenshot) {
            return (TakesScreenshot)this.driver;
        }
        if (this.driver instanceof RemoteWebDriver && ((HasCapabilities)this.driver).getCapabilities().is("takesScreenshot")) {
            return (TakesScreenshot)new Augmenter().augment(this.driver);
        }
        return null;
    }

    protected String takeScreenshot(File file, boolean entirePage) throws UnsupportedOperationException, WebDriverException {
        TakesScreenshot tss = this.getTakesScreenshot();
        if (tss == null) {
            throw new UnsupportedOperationException("webdriver does not support capturing screenshot.");
        }
        file = file.getAbsoluteFile();
        try {
            this.driver.switchTo().defaultContent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            File tmp;
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
                log.info("Make the directory for screenshot: {}", (Object)dir);
            }
            if (entirePage) {
                tmp = File.createTempFile("sstmp-", ".png", dir);
                JavascriptExecutor je = (JavascriptExecutor)tss;
                String getScrollCoord = "return { top: window.scrollY||0, left: window.scrollX };";
                Map initialCoord = (Map)je.executeScript(getScrollCoord, new Object[0]);
                Shutterbug.shootPage((WebDriver)((WebDriver)tss), (ScrollStrategy)ScrollStrategy.WHOLE_PAGE, (int)this.screenshotScrollTimeout).withName(FilenameUtils.removeExtension((String)tmp.getName())).save(dir.getPath());
                if (!initialCoord.equals(je.executeScript(getScrollCoord, new Object[0]))) {
                    je.executeScript("scrollTo(arguments[0]); return false;", new Object[]{initialCoord});
                }
            } else {
                tmp = (File)tss.getScreenshotAs(OutputType.FILE);
            }
            FileUtils.moveFile((File)tmp, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to rename captured screenshot image: " + file, e);
        }
        String path = file.getPath();
        log.info("- captured screenshot: {}", (Object)path);
        this.currentTestCase.getLogRecorder().info("[[ATTACHMENT|" + path + "]]");
        return path;
    }

    protected File normalizeScreenshotFilename(String filename) {
        File file = new File(PathUtils.normalize(filename));
        if (this.screenshotDir != null) {
            return new File(this.screenshotDir, file.getName());
        }
        return file;
    }

    protected File getFilenameForScreenshotAll(String prefix, int index) {
        String filename = String.format("%s_%s_%d.png", prefix, FILE_DATE_TIME.format(ZonedDateTime.now()), index);
        return new File(this.screenshotAllDir, filename);
    }

    protected File getFilenameForScreenshotOnFail(String prefix, int index) {
        String filename = String.format("%s_%s_%d_fail.png", prefix, FILE_DATE_TIME.format(ZonedDateTime.now()), index);
        return new File(this.screenshotOnFailDir, filename);
    }

    @Override
    public String takeEntirePageScreenshot(String filename) throws WebDriverException, UnsupportedOperationException {
        return this.takeScreenshot(this.normalizeScreenshotFilename(filename), true);
    }

    @Override
    public String takeScreenshot(String filename) throws WebDriverException, UnsupportedOperationException {
        return this.takeScreenshot(this.normalizeScreenshotFilename(filename), false);
    }

    @Override
    public String takeScreenshotAll(String prefix, int index) {
        if (this.screenshotAllDir == null) {
            return null;
        }
        try {
            return this.takeScreenshot(this.getFilenameForScreenshotAll(prefix, index), false);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        catch (WebDriverException e) {
            log.warn("- failed to capture screenshot: {} - {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public String takeScreenshotOnFail(String prefix, int index) {
        if (this.screenshotOnFailDir == null) {
            return null;
        }
        try {
            return this.takeScreenshot(this.getFilenameForScreenshotOnFail(prefix, index), true);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        catch (WebDriverException e) {
            log.warn("- failed to capture screenshot: {} - {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public String getInitialWindowHandle() {
        return this.initialWindowHandle;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
        if (this.isW3cAction == null) {
            this.isW3cAction = MouseUtils.isW3cAction(driver);
        }
        this.initialWindowHandle = driver.getWindowHandle();
        this.setDriverTimeout();
    }

    @Override
    public void prepareWebDriver() {
        if (this.preparator == null) {
            return;
        }
        this.setDriver((WebDriver)this.preparator.get());
    }

    public void setWebDriverPreparator(WebDriverPreparator preparator) {
        this.preparator = preparator;
    }

    @Override
    public String getBrowserName() {
        if (this.preparator != null) {
            return this.preparator.getBrowserName();
        }
        String name = this.driver.getClass().getSimpleName();
        if (Strings.isNullOrEmpty((String)name)) {
            return "";
        }
        if (name.endsWith("WebDriver")) {
            return name.substring(0, name.length() - "WebDriver".length()).toLowerCase();
        }
        if (name.endsWith("Driver")) {
            return name.substring(0, name.length() - "Driver".length()).toLowerCase();
        }
        return name.toLowerCase();
    }

    private static void mkdirsForScreenshot(String dirStr, String msg) {
        if (dirStr == null) {
            return;
        }
        File dir = new File(dirStr);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            }
            throw new IllegalArgumentException(dirStr + " is not directory.");
        }
        dir.mkdirs();
        log.info("Make the directory for {}: {}", (Object)msg, (Object)dirStr);
    }

    public void setScreenshotDir(String screenshotDir) throws IllegalArgumentException {
        Runner.mkdirsForScreenshot(screenshotDir, "screenshot");
        this.screenshotDir = screenshotDir;
        log.info("Screenshot directory: {}", (Object)Objects.toString(screenshotDir, "-"));
    }

    public void setScreenshotAllDir(String screenshotAllDir) throws IllegalArgumentException {
        Runner.mkdirsForScreenshot(screenshotAllDir, "screenshot-all");
        this.screenshotAllDir = screenshotAllDir;
        log.info("Screenshot for all commands directory: {}", (Object)Objects.toString(screenshotAllDir, "-"));
    }

    public void setScreenshotOnFailDir(String screenshotOnFailDir) {
        Runner.mkdirsForScreenshot(screenshotOnFailDir, "screenshot-on-fail");
        this.screenshotOnFailDir = screenshotOnFailDir;
        log.info("Screenshot on fail directory: {}", (Object)Objects.toString(screenshotOnFailDir, "-"));
    }

    @Override
    public String getCurrentBaseURL() {
        return LangUtils.isBlank(this.overridingBaseURL) ? this.currentTestCase.getBaseURL() : this.overridingBaseURL;
    }

    public void setOverridingBaseURL(String overridingBaseURL) {
        this.overridingBaseURL = overridingBaseURL;
        log.info("Override base URL: {}", (Object)overridingBaseURL);
    }

    @Override
    public String getOverridingBaseURL() {
        return this.overridingBaseURL;
    }

    public void setIgnoredScreenshotCommand(boolean isIgnoredScreenshotCommand) {
        this.isIgnoredScreenshotCommand = isIgnoredScreenshotCommand;
        log.info("Screenshot command: {}", (Object)(isIgnoredScreenshotCommand ? "ignored" : "enabled"));
    }

    @Override
    public boolean isIgnoredScreenshotCommand() {
        return this.isIgnoredScreenshotCommand;
    }

    @Override
    public boolean isHighlight() {
        return this.isHighlight;
    }

    public void setHighlight(boolean isHighlight) {
        this.isHighlight = isHighlight;
        log.info("Highlight mode: {}", (Object)(isHighlight ? "enabled" : "disabled"));
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public boolean isW3cAction() {
        return this.isW3cAction != null ? this.isW3cAction : false;
    }

    public void setW3cAction(Boolean isW3cAction) {
        this.isW3cAction = isW3cAction;
    }

    public void setScreenshotScrollTimeout(int timeout) {
        this.screenshotScrollTimeout = timeout;
    }

    @Override
    public AlertActionListener getNextNativeAlertActionListener() {
        return this.alertActionListener;
    }

    public void setInteractive(boolean isInteractive) {
        this.isInteractive = isInteractive;
        log.info("Interactive mode: {}", (Object)(isInteractive ? "enabled" : "disabled"));
    }

    private void setDriverTimeout() {
        this.driver.manage().timeouts().pageLoadTimeout((long)this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.driver != null) {
            this.setDriverTimeout();
        }
        log.info("Timeout: {} ms", (Object)timeout);
    }

    @Override
    public void resetRetries() {
        this.retries = 1;
    }

    @Override
    public void incrementRetries() {
        ++this.retries;
    }

    @Override
    public boolean hasReachedMaxRetries() {
        return this.retries >= this.maxRetries;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        log.info("Max retries: {}", (Object)maxRetries);
    }

    public long getInitialSpeed() {
        return this.initialSpeed;
    }

    public void setInitialSpeed(long initialSpeed) {
        this.initialSpeed = initialSpeed;
    }

    @Override
    public void resetSpeed() {
        this.speed = this.initialSpeed;
        log.info("Current speed: {} ms/command", (Object)this.speed);
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(long speed) {
        this.speed = speed;
        log.info("Current speed: {} ms/command", (Object)speed);
    }

    @Override
    public void waitSpeed() {
        if (this.speed > 0L) {
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public SubCommandMap getSubCommandMap() {
        return this.subCommandMap;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public CommandListIterator getCommandListIterator() {
        return this.commandListIteratorStack.peekFirst();
    }

    @Override
    public void pushCommandListIterator(CommandListIterator commandListIterator) {
        this.commandListIteratorStack.push(commandListIterator);
    }

    @Override
    public void popCommandListIterator() {
        this.commandListIteratorStack.pop();
    }

    @Override
    public VarsMap getVarsMap() {
        return this.varsMap;
    }

    public void setVarsMap(VarsMap varsMap) {
        this.varsMap = varsMap;
    }

    @Override
    public TestCaseMap getTestCaseMap() {
        return this.testCaseMap;
    }

    @Override
    public void setTestCaseMap(TestCaseMap testCaseMap) {
        this.testCaseMap = testCaseMap;
    }

    @Override
    public <T extends FlowControlState> T getFlowControlState(ICommand command) {
        return (T)this.flowControlMap.get(command);
    }

    @Override
    public <T extends FlowControlState> void setFlowControlState(ICommand command, T state) {
        this.flowControlMap.put(command, state);
    }

    @Override
    public CollectionMap getCollectionMap() {
        return this.collectionMap;
    }

    @Override
    public RollupRules getRollupRules() {
        if (this.rollupRules == null) {
            this.rollupRules = new RollupRules();
        }
        return this.rollupRules;
    }

    @Override
    public Eval getEval() {
        return this.eval;
    }

    @Override
    public WebDriverElementFinder getElementFinder() {
        return this.elementFinder;
    }

    @Override
    public PageInformation getLatestPageInformation() {
        return this.latestPageInformation;
    }

    @Override
    public void setLatestPageInformation(PageInformation pageInformation) {
        this.latestPageInformation = pageInformation;
    }

    @Override
    public EnumSet<LogFilter> getLogFilter() {
        return this.logFilter;
    }

    @Override
    public CookieFilter getCookieFilter() {
        return this.cookieFilter;
    }

    @Override
    public void setCookieFilter(CookieFilter cookieFilter) {
        this.cookieFilter = cookieFilter;
    }

    @Override
    public JSLibrary getJSLibrary() {
        return this.jsLibrary;
    }

    @Override
    public void setJSLibrary(JSLibrary jsLibrary) {
        this.jsLibrary = jsLibrary;
    }

    @Override
    public ModifierKeyState getModifierKeyState() {
        return this.modifierKeyState;
    }

    @Override
    public void resetState() {
        this.flowControlMap.clear();
        this.collectionMap.clear();
        this.modifierKeyState.reset();
    }

    public Result execute(Selenese selenese) {
        try {
            Result result = selenese.execute(null, this);
            return result;
        }
        catch (InvalidSeleneseException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.resetState();
        }
    }

    @Override
    public boolean isTrue(String expr) {
        boolean isScript = this.getCurrentTestCase().getSourceType() == SourceType.SIDE;
        return (Boolean)this.eval.eval(this, this.varsMap.replaceVars(isScript, expr), "Boolean");
    }

    public Result run(String ... filenames) {
        this.maxTimeTimer.start();
        Result totalResult = Unexecuted.UNEXECUTED;
        ArrayList<TestSuite> testSuiteList = new ArrayList<TestSuite>();
        block6: for (String filename : filenames) {
            Selenese selenese = Parser.parse(filename, this.commandFactory);
            if (selenese.isError()) {
                log.error(selenese.toString());
                totalResult = ((ErrorSource)selenese).getResult();
                continue;
            }
            switch (selenese.getType()) {
                case TEST_PROJECT: 
                case TEST_SUITE: {
                    testSuiteList.add((TestSuite)selenese);
                    continue block6;
                }
                case TEST_CASE: {
                    TestSuite testSuite = Binder.newTestSuite(filename, selenese.getName());
                    testSuite.addSelenese(selenese);
                    testSuiteList.add(testSuite);
                }
            }
        }
        if (totalResult == Unexecuted.UNEXECUTED) {
            for (TestSuite testSuite : testSuiteList) {
                Result result;
                try {
                    result = this.execute(testSuite);
                }
                catch (RuntimeException e) {
                    this.maxTimeTimer.stop();
                    log.error(e.getMessage());
                    throw e;
                }
                totalResult = totalResult.updateWithChildResult(testSuite, result);
            }
        }
        this.maxTimeTimer.stop();
        return totalResult;
    }

    public Result run(String filename, InputStream is) {
        TestSuite testSuite;
        Selenese selenese = Parser.parse(filename, is, this.commandFactory);
        switch (selenese.getType()) {
            case TEST_CASE: {
                testSuite = Binder.newTestSuite(filename, selenese.getName());
                testSuite.addSelenese(selenese);
                break;
            }
            case TEST_SUITE: {
                testSuite = (TestSuite)selenese;
                break;
            }
            default: {
                throw new RuntimeException("Unknown Selenese object: " + selenese);
            }
        }
        return testSuite.execute(null, this);
    }

    public void setJUnitResultDir(String dir) {
        this.jUnitResult.setDir(dir);
        log.info("JUnit result directory: {}", (Object)dir);
    }

    @Override
    public JUnitResult getJUnitResult() {
        return this.jUnitResult;
    }

    public void setHtmlResultDir(String dir) {
        this.htmlResult.setDir(dir);
        log.info("HTML result directory: {}", (Object)dir);
    }

    @Override
    public HtmlResult getHtmlResult() {
        return this.htmlResult;
    }

    public void finish() {
        this.jUnitResult.generateFailsafeSummary();
        this.htmlResult.generateIndex();
    }

    @Override
    public void highlight(Locator ploc, HighlightStyle highlightStyle) {
        List<Locator> selectedFrameLocators = this.elementFinder.getCurrentFrameLocators();
        Map<String, String> prevStyles = highlightStyle.doHighlight(this.driver, this.elementFinder, ploc, selectedFrameLocators);
        if (prevStyles == null) {
            return;
        }
        HighlightStyleBackup backup = new HighlightStyleBackup(prevStyles, ploc, selectedFrameLocators);
        this.styleBackups.push(backup);
    }

    @Override
    public void unhighlight() {
        while (!this.styleBackups.isEmpty()) {
            HighlightStyleBackup backup = this.styleBackups.pop();
            backup.restore(this.driver, this.elementFinder);
        }
    }

    @Override
    public void setupMaxTimeTimer(long maxTime) {
        this.maxTimeTimer = new MaxTimeActiveTimer(maxTime);
    }

    class AlertActionImpl
    implements AlertActionListener {
        boolean accept = true;
        String answer = null;

        AlertActionImpl() {
        }

        @Override
        public void setAccept(boolean accept) {
            this.accept = accept;
        }

        @Override
        public void setAnswer(String answer) {
            this.answer = answer;
        }

        @Override
        public void actionPerformed(Alert alert) {
            if (this.answer != null) {
                alert.sendKeys(this.answer);
            }
            if (this.accept) {
                alert.accept();
            } else {
                alert.dismiss();
            }
            this.answer = null;
            this.accept = true;
        }
    }
}

