/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.runner.converter.Converter;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.config.DefaultConfig;
import jp.vmi.selenium.selenese.config.IConfig;
import jp.vmi.selenium.selenese.log.CookieFilter;
import jp.vmi.selenium.selenese.log.LogFilter;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.CommandDumper;
import jp.vmi.selenium.selenese.utils.LangUtils;
import jp.vmi.selenium.selenese.utils.LoggerUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverManager;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final Pattern EXPR_RE = Pattern.compile("\\s*(?<varName>\\w+)\\s*=\\s*(?<jsonValue>.*)");
    public static final String PROG_TITLE = "Selenese Runner";
    private boolean noExit = false;
    private boolean exitStrictly = false;
    private Integer exitCode = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream is = Main.class.getResourceAsStream("/META-INF/maven/jp.vmi/selenese-runner-java/pom.properties");){
            if (is == null) return "(missing version information)";
            Properties prop = new Properties();
            prop.load(is);
            String string = prop.getProperty("version");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "(missing version information)";
    }

    private void help(String ... msgs) {
        String progName = System.getenv("PROG_NAME");
        if (LangUtils.isBlank(progName)) {
            progName = "java -jar selenese-runner.jar";
        }
        new DefaultConfig(new String[0]).showHelp(new PrintWriter(System.out), PROG_TITLE, Main.getVersion(), progName, msgs);
        this.noExit = false;
        this.exit(Result.Level.USAGE);
    }

    public void run(String[] args) {
        Result.Level exitLevel = Result.Level.UNEXECUTED;
        try {
            DefaultConfig config = new DefaultConfig(args);
            String[] filenames = config.getArgs();
            if (filenames.length == 0) {
                this.help(new String[0]);
            }
            log.info("Start: Selenese Runner {}", (Object)Main.getVersion());
            Runner runner = new Runner();
            runner.setCommandLineArgs(args);
            this.setupRunner(runner, config, filenames);
            Result totalResult = runner.run(filenames);
            runner.finish();
            exitLevel = totalResult.getLevel();
        }
        catch (IllegalArgumentException e) {
            this.help("Error: " + e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitLevel = Result.Level.FATAL;
        }
        this.exit(exitLevel);
    }

    public void setupRunner(Runner runner, IConfig config, String ... filenames) {
        int sstimeout;
        int timeout;
        if (config.getMaxTime() != null) {
            long maxTime = NumberUtils.toLong((String)config.getMaxTime(), (long)0L);
            if (maxTime <= 0L) {
                throw new IllegalArgumentException("Invalid max time value. (" + config.getMaxTime() + ")");
            }
            runner.setupMaxTimeTimer(maxTime * 1000L);
        }
        String driverName = config.getDriver();
        DriverOptions driverOptions = new DriverOptions(config);
        if (driverName == null) {
            if (driverOptions.has(DriverOptions.DriverOption.FIREFOX) || driverOptions.has(DriverOptions.DriverOption.GECKODRIVER)) {
                driverName = "firefox";
            } else if (driverOptions.has(DriverOptions.DriverOption.CHROMEDRIVER)) {
                driverName = "chrome";
            } else if (driverOptions.has(DriverOptions.DriverOption.IEDRIVER)) {
                driverName = "ie";
            } else if (driverOptions.has(DriverOptions.DriverOption.EDGEDRIVER)) {
                driverName = "edge";
            } else if (driverOptions.has(DriverOptions.DriverOption.PHANTOMJS)) {
                driverName = "phantomjs";
            }
        }
        WebDriverManager manager = WebDriverManager.newInstance();
        manager.setWebDriverFactory(driverName);
        manager.setDriverOptions(driverOptions);
        if (config.getCommandFactory() != null) {
            ICommandFactory factory;
            String factoryName = config.getCommandFactory();
            try {
                Class<?> factoryClass = Class.forName(factoryName);
                factory = (ICommandFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("invalid user defined command factory: " + factoryName);
            }
            runner.getCommandFactory().registerCommandFactory(factory);
            log.info("Registered: {}", (Object)factoryName);
        }
        runner.setDriver(manager.get());
        runner.setWebDriverPreparator(manager);
        if (config.isHighlight()) {
            runner.setHighlight(true);
        }
        if (config.isInteractive()) {
            runner.setInteractive(true);
        }
        if (config.getScreenshotDir() != null) {
            runner.setScreenshotDir(config.getScreenshotDir());
        }
        if (config.getScreenshotAll() != null) {
            runner.setScreenshotAllDir(config.getScreenshotAll());
        }
        if (config.getScreenshotOnFail() != null) {
            runner.setScreenshotOnFailDir(config.getScreenshotOnFail());
        }
        if (config.getBaseurl() != null) {
            runner.setOverridingBaseURL(config.getBaseurl());
        }
        if (config.isIgnoreScreenshotCommand()) {
            runner.setIgnoredScreenshotCommand(true);
        }
        if (config.getVar() != null) {
            Gson gson = new Gson();
            String[] varsMap = runner.getVarsMap();
            String[] e = config.getVar();
            int n = e.length;
            for (int i = 0; i < n; ++i) {
                Object value;
                String expr = e[i];
                Matcher matcher = EXPR_RE.matcher(expr);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("invalid var option format: " + expr);
                }
                String name = matcher.group("varName");
                try {
                    value = gson.fromJson(matcher.group("jsonValue"), Object.class);
                }
                catch (JsonSyntaxException e2) {
                    throw new IllegalArgumentException("JSON syntax error: " + expr);
                }
                varsMap.put(name, value);
            }
        }
        if (config.getRollup() != null) {
            String[] rollups;
            for (String rollup : rollups = config.getRollup()) {
                runner.getRollupRules().load(rollup);
            }
        }
        if (config.getLogFilter() != null) {
            LogFilter.parse(runner.getLogFilter(), config.getLogFilter());
        }
        if (config.getCookieFilter() != null) {
            CookieFilter.FilterType filterType;
            String cookieFilter = config.getCookieFilter();
            if (cookieFilter.length() < 2) {
                throw new IllegalArgumentException("invalid cookie filter format: " + cookieFilter);
            }
            switch (cookieFilter.charAt(0)) {
                case '+': {
                    filterType = CookieFilter.FilterType.PASS;
                    break;
                }
                case '-': {
                    filterType = CookieFilter.FilterType.SKIP;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid cookie filter format: " + cookieFilter);
                }
            }
            String pattern = cookieFilter.substring(1);
            runner.setCookieFilter(new CookieFilter(filterType, pattern));
        }
        if (config.getXmlResult() != null) {
            runner.setJUnitResultDir(config.getXmlResult());
        }
        if (config.getHtmlResult() != null) {
            runner.setHtmlResultDir(config.getHtmlResult());
        }
        if ((timeout = NumberUtils.toInt((String)config.getTimeout(), (int)30000)) <= 0) {
            throw new IllegalArgumentException("Invalid timeout value. (" + config.getTimeout() + ")");
        }
        runner.setTimeout(timeout);
        int maxRetries = NumberUtils.toInt((String)config.getMaxRetries(), (int)0);
        if (maxRetries < 0 || maxRetries > 10) {
            throw new IllegalArgumentException("Invalid value: 0 <= maxRetries <= 10. (" + config.getMaxRetries() + ")");
        }
        runner.setMaxRetries(maxRetries);
        int speed = NumberUtils.toInt((String)config.getSetSpeed(), (int)0);
        if (speed < 0) {
            throw new IllegalArgumentException("Invalid speed value. (" + config.getSetSpeed() + ")");
        }
        runner.setInitialSpeed(speed);
        if (config.isNoExit()) {
            this.noExit = true;
        }
        if (config.isStrictExitCode()) {
            this.exitStrictly = true;
        }
        if ((sstimeout = NumberUtils.toInt((String)config.getScreenshotScrollTimeout(), (int)100)) < 0) {
            throw new IllegalArgumentException("Invalid screenshot scroll timeout value. (" + config.getScreenshotScrollTimeout() + ")");
        }
        runner.setScreenshotScrollTimeout(sstimeout);
        runner.setPrintStream(System.out);
    }

    private void dumpThreads() {
        log.trace("Dump threads:");
        Thread.getAllStackTraces().entrySet().stream().sorted((a, b) -> (int)(((Thread)a.getKey()).getId() - ((Thread)b.getKey()).getId())).forEach(entry -> {
            Thread t = (Thread)entry.getKey();
            String daemon = t.isDaemon() ? " (daemon)" : "";
            log.trace("[{}] {}{}", new Object[]{t.getId(), t.getName(), daemon});
            for (StackTraceElement s : (StackTraceElement[])entry.getValue()) {
                int line = s.getLineNumber();
                String lns = line > 0 ? ":" + line : "";
                log.trace("  {}#{}{}", new Object[]{s.getClassName(), s.getMethodName(), lns});
            }
            log.trace("--------");
        });
    }

    protected void exit(Result.Level exitLevel) {
        this.exitCode = this.exitStrictly ? exitLevel.strictExitCode : exitLevel.exitCode;
        WebDriverManager.quitDriversOnAllManagers();
        log.info("Exit code: {} ({})", (Object)this.exitCode, (Object)exitLevel);
        if (!this.noExit) {
            System.exit(this.exitCode);
        }
        this.dumpThreads();
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public static void main(String[] args) {
        LoggerUtils.initLogger();
        Main main = new Main();
        if (args.length == 0) {
            main.help(new String[0]);
        }
        switch (args[0]) {
            case "convert": {
                Converter.main(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "commands": {
                CommandDumper.main(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                main.run(args);
            }
        }
    }
}

