/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.runner.model.side;

import java.util.HashMap;
import java.util.Map;
import jp.vmi.selenium.runner.model.ArgTypes;
import jp.vmi.selenium.runner.model.ICommandMetadata;
import jp.vmi.selenium.runner.model.ICommandSignature;
import jp.vmi.selenium.runner.model.side.SideCommandSignature;
import jp.vmi.selenium.runner.model.utils.CommandsJs;

public class SideCommandMetadata
implements ICommandMetadata {
    private static final SideCommandMetadata METADATA = new SideCommandMetadata();
    private final Map<String, SideCommandSignature> commandSignatureMap = new HashMap<String, SideCommandSignature>();

    public static SideCommandMetadata getInstance() {
        return METADATA;
    }

    private SideCommandMetadata() {
        CommandsJs commandsJs = CommandsJs.load();
        commandsJs.getCommands().forEach((id, map) -> {
            String name = (String)map.get("name");
            String description = (String)map.get("description");
            String target = (String)map.get("target");
            String value = (String)map.get("value");
            SideCommandSignature info = new SideCommandSignature((String)id, name, description, ArgTypes.lookup(target), ArgTypes.lookup(value));
            this.commandSignatureMap.put((String)id, info);
        });
    }

    @Override
    public ICommandSignature getSignature(String id) {
        return this.commandSignatureMap.get(id);
    }
}

