/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.runner.model;

import java.util.HashMap;
import java.util.Map;

public enum ArgTypes {
    NO_ARG("noArg", "no argument", "There is no argument."),
    CSS_LOCATOR("cssLocator", "css locator", "An element locator specified by css."),
    ALERT_TEXT("alertText", "alert text", "text to check"),
    ANSWER("answer", "answer", "The answer to give in response to the prompt pop-up."),
    ATTRIBUTE_LOCATOR("attributeLocator", "attribute locator", "An element locator followed by an @ sign and then the name of the attribute, e.g. \"foo@bar\"."),
    ARRAY_VARIABLE_NAME("arrayVariableName", "array variable name", "The name of a variable containing a JavaScript array."),
    CONDITIONAL_EXPRESSION("conditionalExpression", "conditional expression", "JavaScript expression that returns a boolean result for use in control flow commands."),
    COORD("coord", "coord string", "Specifies the x,y position (e.g., - 10,20) of the mouse event relative to the element found from a locator."),
    EXPECTED_VALUE("expectedValue", "expected value", "The result you expect a variable to contain (e.g., true, false, or some other value)."),
    EXPRESSION("expression", "expression", "The value you'd like to store."),
    FORM_LOCATOR("formLocator", "form locator", "An element locator for the form you want to submit."),
    HANDLE("handle", "window handle", "A handle representing a specific page (tab, or window)."),
    ITERATOR_VARIABLE_NAME("iteratorVariableName", "iterator variable name", "The name of the variable used when iterating over a collection in a looping control flow command (e.g., for each)."),
    JSON("json", "json", "A string representation of a JavaScript object."),
    KEY_SEQUENCE("keySequence", "key sequence", "A sequence of keys to type, can be used to send key strokes (e.g. ${KEY_ENTER})."),
    LOCATOR("locator", "locator", "An element locator."),
    LOCATOR_OF_DRAG_DESTINATION_OBJECT("locatorOfDragDestinationObject", "locator of drag destination object", "The locator of an element whose location (e.g., the center-most pixel within it) will be the point where locator of object to be dragged is dropped."),
    LOCATOR_OF_OBJECT_TO_BE_DRAGGED("locatorOfObjectToBeDragged", "locator of object to be dragged", "The locator of element to be dragged."),
    LOOP_LIMIT("loopLimit", "loop limit", "An optional argument that specifies the maximum number of times a looping control flow command can execute. This protects against infinite loops. The defaults value is set to 1000."),
    MESSAGE("message", "message", "The message to print."),
    OPTION_LOCATOR("optionLocator", "option", "An option locator, typically just an option label (e.g. \"John Smith\")."),
    PATTERN("pattern", "text", "An exact string match. Support for pattern matching is in the works. See https://github.com/SeleniumHQ/selenium-ide/issues/141 for details."),
    REGION("region", "region", "Specify a rectangle with coordinates and lengths (e.g., \"x: 257, y: 300, width: 462, height: 280\")."),
    RESOLUTION("resolution", "resolution", "Specify a window resolution using WidthxHeight. (e.g., 1280x800)."),
    SCRIPT("script", "script", "The JavaScript snippet to run."),
    SELECT_LOCATOR("selectLocator", "select locator", "An element locator identifying a drop-down menu."),
    TEST_CASE("testCase", "test case", "Test case name from the project."),
    TEXT("text", "text", "The text to verify."),
    TIMES("times", "times", "The number of attempts a times control flow loop will execute the commands within its block."),
    URL("url", "url", "The URL to open (may be relative or absolute)."),
    VALUE("value", "value", "The value to type."),
    VARIABLE_NAME("variableName", "variable name", "The name of a variable without brackets."),
    WAIT_TIME("waitTime", "wait time", "The amount of time to wait (in milliseconds)."),
    XPATH("xpath", "xpath", "The xpath expression to evaluate.");

    private static final String PREFIX = "ArgTypes.";
    private static final Map<String, ArgTypes> lookupMap;
    private final String id;
    private final String name;
    private final String description;

    public static ArgTypes lookup(String id) {
        ArgTypes type;
        if (id == null) {
            return NO_ARG;
        }
        if (id.startsWith(PREFIX)) {
            id = id.substring(PREFIX.length());
        }
        if ("option".equals(id)) {
            id = "optionLocator";
        }
        if ((type = lookupMap.get(id)) == null) {
            throw new IllegalArgumentException("No such argument type: ArgTypes." + id);
        }
        return type;
    }

    private ArgTypes(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        lookupMap = new HashMap<String, ArgTypes>();
        for (ArgTypes value : ArgTypes.values()) {
            lookupMap.put(value.id, value);
        }
    }
}

