/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.runner.converter;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jp.vmi.selenium.runner.converter.ConverterOptions;

public class ConvListGenerator {
    private Path inputDir = null;
    private Path outputDir = null;
    private String seleneseExt = ".html";
    private String sideExt = ".side";

    public ConvListGenerator(ConverterOptions options) {
        this.inputDir = options.getIdir() != null ? Paths.get(options.getIdir(), new String[0]) : Paths.get(".", new String[0]);
        this.outputDir = options.getOdir() != null ? Paths.get(options.getOdir(), new String[0]) : this.inputDir;
        if (options.getIext() != null) {
            this.setSeleneseExt(options.getIext());
        }
        if (options.getOext() != null) {
            this.setSideExt(options.getOext());
        }
    }

    public Path getInputDir() {
        return this.inputDir;
    }

    public void setInputDir(Path inputDir) {
        this.inputDir = inputDir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public String getSeleneseExt() {
        return this.seleneseExt;
    }

    public void setSeleneseExt(String seleneseExt) {
        this.seleneseExt = seleneseExt.startsWith(".") ? seleneseExt : "." + seleneseExt;
    }

    public String getSideExt() {
        return this.sideExt;
    }

    public void setSideExt(String sideExt) {
        this.sideExt = sideExt.startsWith(".") ? sideExt : "." + sideExt;
    }

    private Path getOutputFile(Path inputFile) {
        Path rDir = this.inputDir.relativize(inputFile.getParent());
        Path oDir = this.outputDir.resolve(rDir);
        String inputName = inputFile.getFileName().toString();
        String outputName = inputName.substring(0, inputName.length() - this.seleneseExt.length()) + this.sideExt;
        return oDir.resolve(outputName);
    }

    public List<Path[]> generateConversionList() {
        try {
            return Files.walk(this.inputDir, FileVisitOption.FOLLOW_LINKS).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(this.seleneseExt)).sorted().map(path -> new Path[]{path, this.getOutputFile((Path)path)}).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Path[]> generateConversionList(String ... args) {
        ArrayList<Path[]> list = new ArrayList<Path[]>();
        int i = 0;
        Path[] pair = new Path[2];
        while (i < args.length) {
            String name = args[i];
            if (pair[0] == null) {
                if (name.endsWith(this.seleneseExt)) {
                    pair[0] = Paths.get(name, new String[0]);
                    continue;
                }
                if (name.endsWith(this.sideExt)) {
                    throw new IllegalArgumentException("no input file for " + name);
                }
                throw new IllegalArgumentException("illegal argument: " + name);
            }
            if (name.endsWith(this.sideExt)) {
                pair[1] = Paths.get(name, new String[0]);
                list.add(pair);
                pair = new Path[2];
                continue;
            }
            if (name.endsWith(this.seleneseExt)) {
                pair[1] = this.getOutputFile(pair[0]);
                list.add(pair);
                pair = new Path[2];
                pair[0] = Paths.get(name, new String[0]);
                continue;
            }
            throw new IllegalArgumentException("illegal argument: " + name);
        }
        if (pair[0] != null) {
            pair[1] = this.getOutputFile(pair[0]);
            list.add(pair);
        }
        return list;
    }
}

