/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.exec.OS;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverFactory
extends WebDriverFactory {
    public static final String BROWSER_NAME = "safari";

    @Override
    public String getBrowserName() {
        return BROWSER_NAME;
    }

    @Override
    public boolean isProxySupported() {
        return false;
    }

    public static SafariOptions newSafariOptions(DriverOptions driverOptions) {
        SafariOptions options = new SafariOptions();
        Proxy proxy = SafariDriverFactory.newProxy(driverOptions);
        if (proxy != null) {
            options.setProxy(proxy);
        }
        return options;
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        if (!OS.isFamilyMac()) {
            throw new UnsupportedOperationException("Unsupported platform: " + Platform.getCurrent());
        }
        SafariDriverService service = (SafariDriverService)SafariDriverFactory.setupBuilder(new SafariDriverService.Builder(), driverOptions, null).build();
        SafariOptions options = SafariDriverFactory.newSafariOptions(driverOptions);
        options.merge((Capabilities)driverOptions.getCapabilities());
        SafariDriver driver = new SafariDriver(service, options);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

