/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.exec.OS;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;

public class EdgeDriverFactory
extends WebDriverFactory {
    public static final String BROWSER_NAME = "edge";

    @Override
    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public static EdgeOptions newEdgeOptions(DriverOptions driverOptions) {
        EdgeOptions options = new EdgeOptions();
        Proxy proxy = EdgeDriverFactory.newProxy(driverOptions);
        if (proxy != null) {
            options.setProxy(proxy);
        }
        return options;
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        if (!OS.isFamilyWindows()) {
            throw new UnsupportedOperationException("Unsupported platform: " + Platform.getCurrent());
        }
        EdgeDriverService service = (EdgeDriverService)EdgeDriverFactory.setupBuilder(new EdgeDriverService.Builder(), driverOptions, DriverOptions.DriverOption.EDGEDRIVER).build();
        EdgeOptions options = EdgeDriverFactory.newEdgeOptions(driverOptions);
        options.merge((Capabilities)driverOptions.getCapabilities());
        EdgeDriver driver = new EdgeDriver(service, options);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

