/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MouseUtils {
    private static final Logger logger = LoggerFactory.getLogger(MouseUtils.class);
    private static final Pattern MAJOR_VERSION_RE = Pattern.compile("(\\d+).*");

    private MouseUtils() {
    }

    public static Actions moveTo(Context context, WebElement element, Point coord) {
        int x = coord.x;
        int y = coord.y;
        if (context.isW3cAction()) {
            Dimension size = element.getSize();
            if (size != null) {
                x -= size.width / 2;
                y -= size.height / 2;
                logger.info("Adjust offsets for W3C Action command.");
            } else {
                logger.warn("Cannot adjust offsets because failed to get the element size.");
            }
        }
        Actions actions = new Actions(context.getWrappedDriver());
        if (context.isBrowser("htmlunit")) {
            logger.warn("HtmlUnit driver does not support mouse movement to arbitrary X,Y coordinates.");
            return actions.moveToElement(element);
        }
        return actions.moveToElement(element, x, y);
    }

    public static boolean isW3cAction(WebDriver driver) {
        if (!(driver instanceof RemoteWebDriver)) {
            return false;
        }
        Capabilities caps = ((RemoteWebDriver)driver).getCapabilities();
        if (caps == null) {
            return false;
        }
        String browserName = caps.getBrowserName();
        if (browserName == null) {
            return false;
        }
        String version = caps.getVersion();
        if (version == null) {
            return false;
        }
        Matcher matcher = MAJOR_VERSION_RE.matcher(version);
        if (!matcher.matches()) {
            return false;
        }
        int majorVersion = Integer.parseInt(matcher.group(1));
        switch (browserName) {
            case "firefox": {
                return true;
            }
            case "chrome": {
                return majorVersion >= 75;
            }
        }
        return false;
    }
}

