/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EscapeUtils {
    public static final Pattern HTML_RE = Pattern.compile("([<>&\"'\\\\])|\r?\n|\r");
    public static final Map<String, String> HTML_ESC_MAP = new HashMap<String, String>();
    private static Pattern URI_RE;
    private static Pattern JSSTR_RE;

    private EscapeUtils() {
    }

    public static String escapeHtml(String s, boolean newline) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = HTML_RE.matcher(s);
        int index = 0;
        while (matcher.find(index)) {
            int start = matcher.start();
            if (index < start) {
                result.append(s, index, start);
            }
            if (newline) {
                result.append(HTML_ESC_MAP.get(matcher.group()));
            } else {
                String specials = matcher.group(1);
                if (specials != null) {
                    result.append(HTML_ESC_MAP.get(specials));
                } else {
                    result.append('\n');
                }
            }
            index = matcher.end();
        }
        if (index < s.length()) {
            result.append(s, index, s.length());
        }
        return result.toString();
    }

    public static String encodeUri(String s) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = URI_RE.matcher(s);
        int index = 0;
        while (matcher.find(index)) {
            int start = matcher.start();
            if (index < start) {
                result.append(s, index, start);
            }
            for (byte b : matcher.group().getBytes(StandardCharsets.UTF_8)) {
                result.append(String.format("%%%02x", b));
            }
            index = matcher.end();
        }
        if (index < s.length()) {
            result.append(s, index, s.length());
        }
        return result.toString();
    }

    public static String escapeJSString(String s) {
        Matcher matcher = JSSTR_RE.matcher(s);
        if (!matcher.find()) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        int beginIndex = 0;
        do {
            int endIndex;
            if (beginIndex < (endIndex = matcher.start())) {
                result.append(s.substring(beginIndex, endIndex));
            }
            char c = matcher.group().charAt(0);
            result.append('\\');
            switch (c) {
                case '\b': {
                    result.append('b');
                    break;
                }
                case '\t': {
                    result.append('t');
                    break;
                }
                case '\n': {
                    result.append('n');
                    break;
                }
                case '\u000b': {
                    result.append('v');
                    break;
                }
                case '\f': {
                    result.append('f');
                    break;
                }
                case '\r': {
                    result.append('r');
                    break;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    result.append(c);
                    break;
                }
                default: {
                    result.append(String.format("u%04x", c));
                }
            }
        } while (matcher.find(beginIndex = matcher.end()));
        if (beginIndex < s.length()) {
            result.append(s.substring(beginIndex));
        }
        return result.toString();
    }

    static {
        HTML_ESC_MAP.put("<", "&lt;");
        HTML_ESC_MAP.put(">", "&gt;");
        HTML_ESC_MAP.put("&", "&amp;");
        HTML_ESC_MAP.put("\"", "&quot;");
        HTML_ESC_MAP.put("'", "&#39;");
        HTML_ESC_MAP.put("\\", "&#92;");
        HTML_ESC_MAP.put("\r\n", "<br>\n");
        HTML_ESC_MAP.put("\n", "<br>\n");
        HTML_ESC_MAP.put("\r", "<br>\n");
        URI_RE = Pattern.compile("[^;,/?:@&=+$A-Za-z0-9\\-_.!~*'()#]+");
        JSSTR_RE = Pattern.compile("[\\u0000-\\u001f\u2028\u2029\\\\\"']");
    }
}

