/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public final class DateTimeUtils {
    private static DateTimeFormatter formatWithMS;
    private static DateTimeFormatter formatWithoutMS;
    private static DateTimeFormatter formatTimeWithMS;
    private static final DateTimeFormatter formatIso8601;

    private DateTimeUtils() {
    }

    public static void setFormat(String ymd, String sep1, String hms, String ms, String sep2, String tz) {
        formatWithMS = DateTimeFormatter.ofPattern(ymd + sep1 + hms + ms + sep2 + tz);
        formatWithoutMS = DateTimeFormatter.ofPattern(ymd + sep1 + hms + sep2 + tz);
        formatTimeWithMS = DateTimeFormatter.ofPattern(hms + ms);
    }

    private static ZonedDateTime toZonedDateTime(long time) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
    }

    public static String formatWithMS(long time) {
        return formatWithMS.format(DateTimeUtils.toZonedDateTime(time));
    }

    public static String formatWithoutMS(long time) {
        return formatWithoutMS.format(DateTimeUtils.toZonedDateTime(time));
    }

    public static String formatTimeWithMS(long time) {
        return formatTimeWithMS.format(DateTimeUtils.toZonedDateTime(time));
    }

    public static String formatIso8601(long time) {
        return formatIso8601.format(DateTimeUtils.toZonedDateTime(time));
    }

    public static TemporalAccessor parseIso8601(String timeStr) {
        return formatIso8601.parse(timeStr);
    }

    static {
        formatIso8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
        DateTimeUtils.setFormat("yyyy-MM-dd", " ", "HH:mm:ss", ".SSS", " ", "XXX");
    }
}

