/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.subcommand;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.utils.MouseUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MouseEventHandler
implements ISubCommand<Void> {
    private static final Logger log = LoggerFactory.getLogger(MouseEventHandler.class);
    private static final String NEW_MOUSE_EVENT = "var newMouseEvent = function(element, event, init) {try {return new MouseEvent(event, init);} catch (e) {var e = document.createEvent('MouseEvents');e.initMouseEvent(event, true, true, window, 0, init.screenX, init.screenY, init.clientX, init.clientY, init.ctrlKey, init.altKey, init.shiftKey, init.metaKey, init.button, element);return e;}};";
    private static final String FIRE_MOUSE_OVER_EVENT = "(function(element) {var newMouseEvent = function(element, event, init) {try {return new MouseEvent(event, init);} catch (e) {var e = document.createEvent('MouseEvents');e.initMouseEvent(event, true, true, window, 0, init.screenX, init.screenY, init.clientX, init.clientY, init.ctrlKey, init.altKey, init.shiftKey, init.metaKey, init.button, element);return e;}};element.dispatchEvent(newMouseEvent(element, 'mouseover', {}));element.dispatchEvent(newMouseEvent(element, 'mouseenter', {}));})(arguments[0])";
    private static final String FIRE_MOUSE_OUT_EVENT = "(function(element) {var newMouseEvent = function(element, event, init) {try {return new MouseEvent(event, init);} catch (e) {var e = document.createEvent('MouseEvents');e.initMouseEvent(event, true, true, window, 0, init.screenX, init.screenY, init.clientX, init.clientY, init.ctrlKey, init.altKey, init.shiftKey, init.metaKey, init.button, element);return e;}};element.dispatchEvent(newMouseEvent(element, 'mouseleave', {}));element.dispatchEvent(newMouseEvent(element, 'mouseout', {}));})(arguments[0])";
    private static final String FIRE_MOUSE_EVENT = "(function(element, event, init) {var newMouseEvent = function(element, event, init) {try {return new MouseEvent(event, init);} catch (e) {var e = document.createEvent('MouseEvents');e.initMouseEvent(event, true, true, window, 0, init.screenX, init.screenY, init.clientX, init.clientY, init.ctrlKey, init.altKey, init.shiftKey, init.metaKey, init.button, element);return e;}};element.dispatchEvent(newMouseEvent(element, event, init));}).apply(null, arguments)";
    private static final int ARG_LOCATOR = 0;
    private static final int ARG_COORD = 1;
    private final MouseEventType eventType;

    public MouseEventHandler(MouseEventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public String getName() {
        return this.eventType.commandName;
    }

    @Override
    public ArgumentType[] getArgumentTypes() {
        return this.eventType.argTypes;
    }

    private static <T> T eval(WebDriver driver, String script, Object ... args) {
        return (T)((JavascriptExecutor)driver).executeScript(script, args);
    }

    private static Point coordToPoint(String coordString) {
        String[] pair = coordString.trim().split("\\s*,\\s*");
        int x = (int)Double.parseDouble(pair[0]);
        int y = (int)Double.parseDouble(pair[1]);
        return new Point(x, y);
    }

    private static Point calcOffset(int vpWidth, int vpHeight, Point elemLocation, Dimension elemSize) {
        int xOffset = elemSize.width / 2;
        int yOffset = elemSize.height / 2;
        if (elemLocation.x + elemSize.width > 0 && elemLocation.x < vpWidth) {
            if (elemLocation.x + xOffset < 0) {
                xOffset = 0;
            } else if (elemLocation.x + xOffset >= vpWidth) {
                xOffset = vpWidth - 1;
            }
        }
        if (elemLocation.y + elemSize.height > 0 && elemLocation.y < vpHeight) {
            if (elemLocation.y + yOffset < 0) {
                yOffset = 0;
            } else if (elemLocation.y + yOffset >= vpHeight) {
                yOffset = vpHeight - 1;
            }
        }
        return new Point(xOffset, yOffset);
    }

    private static Point calcOffsetOutsideElement(int vpWidth, int vpHeight, Point elemLocation, Dimension elemSize) {
        int yOffset;
        int xOffset;
        int inside = 0;
        if (elemLocation.x - 1 >= 0) {
            xOffset = -1;
        } else if (elemLocation.x + elemSize.width < vpWidth) {
            xOffset = elemSize.width;
        } else {
            xOffset = vpWidth / 2;
            ++inside;
        }
        if (elemLocation.y - 1 >= 0) {
            yOffset = -1;
        } else if (elemLocation.y + elemSize.height < vpHeight) {
            yOffset = elemSize.height;
        } else {
            yOffset = vpHeight / 2;
            ++inside;
        }
        return inside < 2 ? new Point(xOffset, yOffset) : null;
    }

    @Override
    public Void execute(Context context, String ... args) {
        Function<Actions, Actions> afterMovingMouse;
        Point coord;
        log.debug("Mouse event: {}", (Object)this.eventType.commandName);
        WebDriver driver = context.getWrappedDriver();
        List viewportSize = (List)MouseEventHandler.eval(driver, "return [document.documentElement.clientWidth, document.documentElement.clientHeight];", new Object[0]);
        int vpWidth = ((Long)viewportSize.get(0)).intValue();
        int vpHeight = ((Long)viewportSize.get(1)).intValue();
        WebElement element = context.findElement(args[0]);
        Dimension elemSize = element.getSize();
        Point elemLocation = element.getLocation();
        log.debug("Viewport Size: ({}, {}) / Element Location: {} / Element Size: {}", new Object[]{vpWidth, vpHeight, elemLocation, elemSize});
        switch (this.eventType) {
            case MOUSE_OVER: 
            case MOUSE_MOVE: {
                coord = MouseEventHandler.calcOffset(vpWidth, vpHeight, elemLocation, elemSize);
                afterMovingMouse = actions -> actions;
                break;
            }
            case MOUSE_OUT: {
                coord = MouseEventHandler.calcOffsetOutsideElement(vpWidth, vpHeight, elemLocation, elemSize);
                if (coord != null) {
                    log.debug("Move to: ({}, {}) on {}", new Object[]{coord.x, coord.y, element});
                    afterMovingMouse = actions -> actions;
                    break;
                }
                log.debug("Fire \"mouseleave\" and \"mouseout\" events by JS.");
                MouseEventHandler.eval(driver, FIRE_MOUSE_OUT_EVENT, element);
                return null;
            }
            case MOUSE_MOVE_AT: {
                coord = MouseEventHandler.coordToPoint(args[1]);
                afterMovingMouse = actions -> actions;
                break;
            }
            case MOUSE_DOWN: {
                coord = MouseEventHandler.calcOffset(vpWidth, vpHeight, elemLocation, elemSize);
                afterMovingMouse = actions -> actions.clickAndHold();
                break;
            }
            case MOUSE_DOWN_AT: {
                coord = MouseEventHandler.coordToPoint(args[1]);
                afterMovingMouse = actions -> actions.clickAndHold();
                break;
            }
            case MOUSE_UP: {
                coord = MouseEventHandler.calcOffset(vpWidth, vpHeight, elemLocation, elemSize);
                afterMovingMouse = actions -> actions.release();
                break;
            }
            case MOUSE_UP_AT: {
                coord = MouseEventHandler.coordToPoint(args[1]);
                afterMovingMouse = actions -> actions.release();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported command: " + this.eventType.commandName);
            }
        }
        try {
            afterMovingMouse.apply(MouseUtils.moveTo(context, element, coord)).build().perform();
        }
        catch (MoveTargetOutOfBoundsException e) {
            log.warn("Cannot mouse pointer move to element: {}", (Object)e.getMessage());
            log.warn("Only fire \"{}\" event by JS.", (Object)this.eventType.eventName);
            if (this.eventType == MouseEventType.MOUSE_OVER) {
                MouseEventHandler.eval(driver, FIRE_MOUSE_OVER_EVENT, new Object[0]);
            }
            if (this.eventType.hasCoord) {
                HashMap<String, Integer> init = new HashMap<String, Integer>();
                init.put("clientX", coord.x);
                init.put("clientY", coord.y);
                MouseEventHandler.eval(driver, FIRE_MOUSE_EVENT, this.eventType.eventName, init);
            }
            MouseEventHandler.eval(driver, FIRE_MOUSE_EVENT, this.eventType.eventName);
        }
        return null;
    }

    @Override
    public int getArgumentCount() {
        return this.eventType.argTypes.length;
    }

    public static enum MouseEventType {
        MOUSE_OVER(ArgumentType.LOCATOR),
        MOUSE_OUT(ArgumentType.LOCATOR),
        MOUSE_MOVE(ArgumentType.LOCATOR),
        MOUSE_MOVE_AT(ArgumentType.LOCATOR, ArgumentType.VALUE),
        MOUSE_DOWN(ArgumentType.LOCATOR),
        MOUSE_DOWN_AT(ArgumentType.LOCATOR, ArgumentType.VALUE),
        MOUSE_UP(ArgumentType.LOCATOR),
        MOUSE_UP_AT(ArgumentType.LOCATOR, ArgumentType.VALUE);

        private String commandName;
        private String eventName;
        private ArgumentType[] argTypes;
        private boolean hasCoord;

        private MouseEventType(ArgumentType ... argTypes) {
            String[] words = this.name().split("_");
            StringBuilder commandName = new StringBuilder(words[0].toLowerCase());
            StringBuilder eventName = new StringBuilder(words[0].toLowerCase());
            for (int i = 1; i < words.length; ++i) {
                String word = words[i];
                commandName.append(word.charAt(0));
                if (word.length() > 1) {
                    commandName.append(word.substring(1).toLowerCase());
                }
                if (i >= words.length - 1 && word.equals("AT")) continue;
                eventName.append(word.toLowerCase());
            }
            this.commandName = commandName.toString();
            this.eventName = eventName.toString();
            this.argTypes = argTypes;
            this.hasCoord = argTypes.length == 2;
        }
    }
}

