/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.util.Iterator;
import jp.vmi.selenium.runner.model.side.SideProject;
import jp.vmi.selenium.runner.model.side.SideSuite;
import jp.vmi.selenium.runner.model.side.SideTest;
import jp.vmi.selenium.selenese.parser.AbstractTestElementIterator;
import jp.vmi.selenium.selenese.parser.CommandIterator;
import jp.vmi.selenium.selenese.parser.SideCommandIterator;
import jp.vmi.selenium.selenese.parser.TestCaseEntry;
import jp.vmi.selenium.selenese.parser.TestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestElementIteratorFactory;

public class SideTestCaseIterator
extends AbstractTestElementIterator<TestCaseEntry>
implements TestCaseIterator {
    private final SideProject side;
    private final Iterator<SideTest> iter;

    public SideTestCaseIterator(SideProject side, String testSuiteId) {
        super(side.getFilename());
        this.side = side;
        SideSuite suite = side.getSuiteMap().get(testSuiteId);
        this.setName(suite.getName());
        this.setId(suite.getId());
        this.iter = suite.getTests().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public TestCaseEntry next() {
        SideTest test = this.iter.next();
        return new TestCaseEntry(true, test.getId(), test.getName());
    }

    @Override
    public TestElementIteratorFactory<CommandIterator, TestCaseEntry> getCommandIteratorFactory() {
        return caseEntry -> new SideCommandIterator(this.side, caseEntry.id);
    }
}

