/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.util.NoSuchElementException;
import javax.xml.transform.TransformerException;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.parser.AbstractTestElementIterator;
import jp.vmi.selenium.selenese.parser.CommandIterator;
import jp.vmi.selenium.selenese.parser.ParserUtils;
import jp.vmi.selenium.selenese.parser.SeleneseIteratorFactory;
import jp.vmi.selenium.selenese.parser.TestCaseEntry;
import jp.vmi.selenium.selenese.parser.TestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestElementIterator;
import jp.vmi.selenium.selenese.parser.TestElementIteratorFactory;
import jp.vmi.selenium.selenese.utils.PathUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeleneseTestCaseIterator
extends AbstractTestElementIterator<TestCaseEntry>
implements TestCaseIterator {
    private final NodeList nodeList;
    private int index = 0;

    public SeleneseTestCaseIterator(String filename, Document document) throws InvalidSeleneseException {
        super(filename);
        this.setName(ParserUtils.getNameFromFilename(filename));
        this.setId(filename);
        try {
            this.nodeList = XPathAPI.selectNodeList((Node)document, (String)"//TBODY/TR/TD/A/@href");
        }
        catch (TransformerException e) {
            throw new InvalidSeleneseException(e, filename, null);
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.nodeList.getLength();
    }

    @Override
    public TestCaseEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String tcFilename = this.nodeList.item(this.index++).getNodeValue();
        return new TestCaseEntry(false, tcFilename, tcFilename);
    }

    private String getParentDir() {
        String filename = PathUtils.normalize(this.getFilename());
        if (filename == null) {
            return null;
        }
        return FilenameUtils.getFullPathNoEndSeparator((String)filename);
    }

    @Override
    public TestElementIteratorFactory<CommandIterator, TestCaseEntry> getCommandIteratorFactory() throws InvalidSeleneseException {
        String parentDir = this.getParentDir();
        return caseEntry -> {
            String filename = caseEntry.id;
            filename = FilenameUtils.getPrefixLength((String)filename) == 0 && parentDir != null ? PathUtils.concat(parentDir, filename) : PathUtils.normalize(filename);
            TestElementIterator<?> iter = SeleneseIteratorFactory.newIterator(filename);
            if (!(iter instanceof CommandIterator)) {
                throw new InvalidSeleneseException(filename + " is not test-case file.", filename, caseEntry.name);
            }
            return (CommandIterator)iter;
        };
    }
}

