/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.parser.ParserUtils;
import jp.vmi.selenium.selenese.parser.SeleneseCommandIterator;
import jp.vmi.selenium.selenese.parser.SeleneseTestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestElementIterator;
import org.apache.xpath.XPathAPI;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SeleneseIteratorFactory {
    private static final String TEST_CASE_PROFILE = "http://selenium-ide.openqa.org/profiles/test-case";
    private static final String DEFAULT_BASE_URL = "about:blank";

    public static TestElementIterator<?> newIterator(String filename) throws InvalidSeleneseException {
        TestElementIterator<?> testElementIterator;
        FileInputStream is = new FileInputStream(filename);
        try {
            testElementIterator = SeleneseIteratorFactory.newIterator(filename, is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidSeleneseException(e, filename, ParserUtils.getNameFromFilename(filename));
            }
        }
        ((InputStream)is).close();
        return testElementIterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TestElementIterator<?> newIterator(String filename, InputStream is) throws InvalidSeleneseException {
        try {
            DOMParser dp = new DOMParser();
            dp.setEntityResolver(null);
            dp.setFeature("http://xml.org/sax/features/namespaces", false);
            dp.setFeature("http://apache.org/xml/features/include-comments", true);
            dp.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
            dp.parse(new InputSource(is));
            Document document = dp.getDocument();
            Node seleniumBase = XPathAPI.selectSingleNode((Node)document, (String)"/HTML/HEAD/LINK[@rel='selenium.base']/@href");
            if (seleniumBase != null) {
                String baseURL = seleniumBase.getNodeValue();
                SeleneseCommandIterator seleneseCommandIterator = new SeleneseCommandIterator(filename, document, baseURL);
                return seleneseCommandIterator;
            }
            Node profile = XPathAPI.selectSingleNode((Node)document, (String)"/HTML/HEAD/@profile");
            if (profile != null && TEST_CASE_PROFILE.equals(profile.getNodeValue())) {
                SeleneseCommandIterator seleneseCommandIterator = new SeleneseCommandIterator(filename, document, DEFAULT_BASE_URL);
                return seleneseCommandIterator;
            }
            Node suiteTable = XPathAPI.selectSingleNode((Node)document, (String)"/HTML/BODY/TABLE[@id='suiteTable']");
            if (suiteTable == null) throw new InvalidSeleneseException("Not selenese script. Missing neither 'selenium.base' link nor table with 'suiteTable' id", filename, null);
            SeleneseTestCaseIterator seleneseTestCaseIterator = new SeleneseTestCaseIterator(filename, document);
            return seleneseTestCaseIterator;
        }
        catch (IOException | TransformerException | SAXException e) {
            throw new InvalidSeleneseException(e, filename, null);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

