/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.util.Arrays;
import jp.vmi.selenium.runner.model.side.SideCommand;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.parser.TestElementEntry;

public abstract class CommandEntry
extends TestElementEntry {
    CommandEntry(String id, String name) {
        super(id, name);
    }

    public abstract void addToTestCase(TestCase var1, ICommandFactory var2);

    public static CommandEntry newInstance(String id, String name, String ... args) {
        return new SeleneseCommandEntry(id, name, args);
    }

    public static CommandEntry newInstance(SideCommand sideCommand) {
        return new SideCommandEntry(sideCommand);
    }

    static class SideCommandEntry
    extends CommandEntry {
        public final SideCommand sideCommand;

        SideCommandEntry(SideCommand sideCommand) {
            super(sideCommand.getId(), sideCommand.getCommand());
            this.sideCommand = sideCommand;
        }

        private static String toNonNullString(String s) {
            return s != null ? s : "";
        }

        @Override
        public void addToTestCase(TestCase testCase, ICommandFactory commandFactory) {
            String comment = this.sideCommand.getComment();
            if (comment != null && !comment.isEmpty()) {
                testCase.addCommand(index -> commandFactory.newCommand((int)index, "comment", comment));
            }
            testCase.addCommand(index -> {
                ICommand command = commandFactory.newCommand((int)index, this.name, SideCommandEntry.toNonNullString(this.sideCommand.getTarget()), SideCommandEntry.toNonNullString(this.sideCommand.getValue()));
                command.setSideCommand(this.sideCommand);
                return command;
            });
        }
    }

    static class SeleneseCommandEntry
    extends CommandEntry {
        public final String[] args;

        SeleneseCommandEntry(String id, String name, String[] args) {
            super(id, name);
            this.args = (String[])Arrays.stream(args).map(item -> item != null ? item : "").toArray(String[]::new);
        }

        @Override
        public void addToTestCase(TestCase testCase, ICommandFactory commandFactory) {
            testCase.addCommand(index -> commandFactory.newCommand((int)index, this.name, this.args));
        }
    }
}

