/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.log;

import java.util.Date;
import java.util.Objects;
import jp.vmi.selenium.selenese.log.CookieKey;
import jp.vmi.selenium.selenese.utils.DateTimeUtils;

public class CookieValue {
    public final CookieKey key;
    public final String value;
    public final Date expiry;

    public CookieValue(CookieKey key, String value, Date expiry) {
        this.key = key;
        this.value = value;
        if (expiry != null && (expiry.getTime() & 0xFFFF000000000000L) == 0x7FFF000000000000L) {
            expiry = null;
        }
        this.expiry = expiry;
    }

    public boolean equalsWithoutExpiry(CookieValue other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.key.equals(other.key) && Objects.equals(this.value, other.value) && this.expiry == null == (other.expiry == null);
    }

    public String toString() {
        String expiryString = this.expiry != null ? DateTimeUtils.formatWithoutMS(this.expiry.getTime()) : "*";
        return this.key.name + "=[" + this.value + "] (domain=" + this.key.domain + ", path=" + this.key.path + ", expire=" + expiryString + ")";
    }
}

