/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;

public class SetWindowSize
extends AbstractCommand {
    private static final int ARG_RESOLUTION = 0;
    private final Pattern RESOLUTION_RE = Pattern.compile("(?<width>\\d+)x(?<height>\\d+)");

    SetWindowSize(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String resolution = curArgs[0];
        Matcher matcher = this.RESOLUTION_RE.matcher(resolution);
        if (!matcher.matches()) {
            return new Error("Invalid resolution format. (e.g,. 1280x800)");
        }
        int width = Integer.parseInt(matcher.group("width"));
        int height = Integer.parseInt(matcher.group("height"));
        WebDriver driver = context.getWrappedDriver();
        driver.manage().window().setSize(new Dimension(width, height));
        return Success.SUCCESS;
    }
}

