/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import jp.vmi.selenium.selenese.utils.LangUtils;

public class SetTimeout
extends AbstractCommand {
    private static final int ARG_TIMEOUT = 0;

    SetTimeout(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    public boolean mayUpdateScreen() {
        return false;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String timeout = curArgs[0];
        if (LangUtils.isBlank(timeout)) {
            return new Warning("the argument of setTimeout is ignored: empty.");
        }
        try {
            context.setTimeout(Integer.parseInt(timeout));
            return Success.SUCCESS;
        }
        catch (NumberFormatException e) {
            return new Warning("the argument of setTimeout is ignored: invalid number format: " + timeout);
        }
    }
}

