/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Failure;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import jp.vmi.selenium.selenese.utils.LangUtils;

public class Pause
extends AbstractCommand {
    private static final int ARG_PAUSE_MSEC = 0;

    Pause(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String pauseMSec = curArgs[0];
        if (LangUtils.isBlank(pauseMSec)) {
            return new Warning("pause is ignored: empty time.");
        }
        try {
            Thread.sleep(Long.parseLong(pauseMSec));
            return Success.SUCCESS;
        }
        catch (NumberFormatException e) {
            return new Warning("pause is ignored: invalid time: " + pauseMSec);
        }
        catch (InterruptedException e) {
            return new Failure(e);
        }
    }
}

