/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class DragAndDropToObject
extends AbstractCommand {
    private static final int ARG_LOCATOR_FROM = 0;
    private static final int ARG_LOCATOR_TO = 1;

    DragAndDropToObject(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR, ArgumentType.LOCATOR);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        WebDriver driver = context.getWrappedDriver();
        WebDriverElementFinder finder = context.getElementFinder();
        WebElement elementFrom = finder.findElement(driver, curArgs[0]);
        WebElement elementTo = finder.findElement(driver, curArgs[1]);
        new Actions(driver).dragAndDrop(elementFrom, elementTo).perform();
        return Success.SUCCESS;
    }
}

