/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class DragAndDrop
extends AbstractCommand {
    private static final int ARG_LOCATOR = 0;
    private static final int ARG_MOVEMENTS_STRING = 1;

    DragAndDrop(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        int yDelta;
        int xDelta;
        String[] parts = curArgs[1].split("\\s*,\\s*", 2);
        try {
            xDelta = Integer.parseInt(parts[0].trim());
            yDelta = Integer.parseInt(parts[1].trim());
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return new Error("Invalid movements: " + curArgs[1]);
        }
        WebDriver driver = context.getWrappedDriver();
        WebElement element = context.getElementFinder().findElement(driver, curArgs[0]);
        new Actions(driver).dragAndDropBy(element, xDelta, yDelta).perform();
        return Success.SUCCESS;
    }
}

