/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.function.Function;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.result.Result;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

final class ClickHandler {
    private ClickHandler() {
    }

    static Result handleClick(Context context, String locator, Function<WebElement, Result> found) {
        WebDriver driver = context.getWrappedDriver();
        boolean isRetryable = !context.getCurrentTestCase().getSourceType().isSelenese();
        int timeout = context.getTimeout();
        while (true) {
            WebElement element = context.getElementFinder().findElementWithTimeout(driver, locator, isRetryable, timeout);
            try {
                context.getJSLibrary().replaceAlertMethod(driver, element);
                return found.apply(element);
            }
            catch (StaleElementReferenceException e) {
                continue;
            }
            break;
        }
    }
}

