/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.SourceType;
import jp.vmi.selenium.selenese.TestProject;
import jp.vmi.selenium.selenese.TestSuiteParser;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.parser.TestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestElementIteratorFactory;
import jp.vmi.selenium.selenese.parser.TestSuiteEntry;
import jp.vmi.selenium.selenese.parser.TestSuiteIterator;

public final class TestProjectParser {
    public static Selenese parse(SourceType sourceType, TestSuiteIterator suiteIter, ICommandFactory commandFactory) {
        TestProject testProject = Binder.newTestProject(suiteIter.getFilename(), suiteIter.getName());
        try {
            TestElementIteratorFactory<TestCaseIterator, TestSuiteEntry> caseIterFactory = suiteIter.getTestCaseIteratorFactory();
            for (TestSuiteEntry entry : suiteIter) {
                TestCaseIterator caseIter = caseIterFactory.getTestElementIterator(entry);
                Selenese selenese = TestSuiteParser.parse(sourceType, caseIter, commandFactory);
                testProject.addSelenese(selenese);
            }
        }
        catch (InvalidSeleneseException e) {
            testProject.addSelenese(Binder.newErrorTestSuite(e.getFilename(), e));
        }
        return suiteIter.isDummy() ? testProject.pullOutFirstFromSeleneseList() : testProject;
    }
}

